/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.ShortObjectHashMap;

public class ShortObjectScatterMap<VType>
extends ShortObjectHashMap<VType> {
    public ShortObjectScatterMap() {
        this(4);
    }

    public ShortObjectScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ShortObjectScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(short key) {
        return BitMixer.mixPhi(key);
    }

    public static <VType> ShortObjectScatterMap<VType> from(short[] keys, VType[] values2) {
        if (keys.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortObjectScatterMap<VType> map2 = new ShortObjectScatterMap<VType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map2.put(keys[i], values2[i]);
        }
        return map2;
    }
}

