/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.ShortBufferVisualizer;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.ShortObjectAssociativeContainer;
import com.carrotsearch.hppc.ShortObjectMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.cursors.ShortObjectCursor;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.predicates.ShortObjectPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import com.carrotsearch.hppc.procedures.ShortObjectProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public class ShortObjectHashMap<VType>
implements ShortObjectMap<VType>,
Preallocable,
Cloneable {
    public short[] keys;
    public Object[] values;
    protected int keyMixer;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public ShortObjectHashMap() {
        this(4);
    }

    public ShortObjectHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ShortObjectHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public ShortObjectHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public ShortObjectHashMap(ShortObjectAssociativeContainer<? extends VType> container2) {
        this(container2.size());
        this.putAll(container2);
    }

    @Override
    public VType put(short key, VType value2) {
        short existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == 0) {
            this.hasEmptyKey = true;
            Object previousValue = this.values[mask + 1];
            this.values[mask + 1] = value2;
            return (VType)previousValue;
        }
        short[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                Object previousValue = this.values[slot];
                this.values[slot] = value2;
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value2);
        } else {
            keys[slot] = key;
            this.values[slot] = value2;
        }
        ++this.assigned;
        return null;
    }

    @Override
    public int putAll(ShortObjectAssociativeContainer<? extends VType> container2) {
        int count2 = this.size();
        for (ShortObjectCursor<VType> shortObjectCursor : container2) {
            this.put(shortObjectCursor.key, shortObjectCursor.value);
        }
        return this.size() - count2;
    }

    @Override
    public int putAll(Iterable<? extends ShortObjectCursor<? extends VType>> iterable) {
        int count2 = this.size();
        for (ShortObjectCursor<VType> shortObjectCursor : iterable) {
            this.put(shortObjectCursor.key, shortObjectCursor.value);
        }
        return this.size() - count2;
    }

    public boolean putIfAbsent(short key, VType value2) {
        if (!this.containsKey(key)) {
            this.put(key, value2);
            return true;
        }
        return false;
    }

    @Override
    public VType remove(short key) {
        short existing;
        int mask = this.mask;
        if (key == 0) {
            this.hasEmptyKey = false;
            Object previousValue = this.values[mask + 1];
            this.values[mask + 1] = null;
            return (VType)previousValue;
        }
        short[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                Object previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    @Override
    public int removeAll(ShortContainer other) {
        int before = this.size();
        if (other.size() >= this.size() && other instanceof ShortLookupContainer) {
            if (this.hasEmptyKey && other.contains((short)0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = null;
            }
            short[] keys = this.keys;
            int slot = 0;
            int max2 = this.mask;
            while (slot <= max2) {
                short existing = keys[slot];
                if (existing != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (ShortCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ShortObjectPredicate<? super VType> predicate) {
        int before = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply((short)0, this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = null;
        }
        short[] keys = this.keys;
        Object[] values2 = this.values;
        int slot = 0;
        while (slot <= mask) {
            short existing = keys[slot];
            if (existing != 0 && predicate.apply(existing, values2[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply((short)0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = null;
        }
        short[] keys = this.keys;
        int slot = 0;
        int max2 = this.mask;
        while (slot <= max2) {
            short existing = keys[slot];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public VType get(short key) {
        short existing;
        if (key == 0) {
            return (VType)(this.hasEmptyKey ? this.values[this.mask + 1] : null);
        }
        short[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    @Override
    public VType getOrDefault(short key, VType defaultValue2) {
        short existing;
        if (key == 0) {
            return (VType)(this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue2);
        }
        short[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue2;
    }

    @Override
    public boolean containsKey(short key) {
        short existing;
        if (key == 0) {
            return this.hasEmptyKey;
        }
        short[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(short key) {
        short existing;
        int mask = this.mask;
        if (key == 0) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        short[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index2) {
        assert (index2 < 0 || index2 >= 0 && index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        return index2 >= 0;
    }

    @Override
    public VType indexGet(int index2) {
        assert (index2 >= 0) : "The index must point at an existing key.";
        assert (index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        return (VType)this.values[index2];
    }

    @Override
    public VType indexReplace(int index2, VType newValue) {
        assert (index2 >= 0) : "The index must point at an existing key.";
        assert (index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        Object previousValue = this.values[index2];
        this.values[index2] = newValue;
        return (VType)previousValue;
    }

    @Override
    public void indexInsert(int index2, short key, VType value2) {
        assert (index2 < 0) : "The index must not point at an existing key.";
        index2 ^= 0xFFFFFFFF;
        if (key == 0) {
            assert (index2 == this.mask + 1);
            this.values[index2] = value2;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index2] == 0);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index2, key, value2);
            } else {
                this.keys[index2] = key;
                this.values[index2] = value2;
            }
            ++this.assigned;
        }
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, (short)0);
        Arrays.fill(this.values, null);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (ShortObjectCursor<VType> c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((ShortObjectHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(ShortObjectHashMap<?> other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (ShortObjectCursor<?> c : other) {
            short key = c.key;
            if (this.containsKey(key) && Objects.equals(this.get(key), c.value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            short[] prevKeys = this.keys;
            Object[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public Iterator<ShortObjectCursor<VType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ShortObjectProcedure<? super VType>> T forEach(T procedure) {
        short[] keys = this.keys;
        Object[] values2 = this.values;
        if (this.hasEmptyKey) {
            procedure.apply((short)0, (Object)values2[this.mask + 1]);
        }
        int max2 = this.mask;
        for (int slot = 0; slot <= max2; ++slot) {
            if (keys[slot] == 0) continue;
            procedure.apply(keys[slot], (Object)values2[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ShortObjectPredicate<? super VType>> T forEach(T predicate) {
        short[] keys = this.keys;
        Object[] values2 = this.values;
        if (this.hasEmptyKey && !predicate.apply((short)0, (Object)values2[this.mask + 1])) {
            return predicate;
        }
        int max2 = this.mask;
        for (int slot = 0; slot <= max2 && (keys[slot] == 0 || predicate.apply(keys[slot], (Object)values2[slot])); ++slot) {
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public ObjectCollection<VType> values() {
        return new ValuesContainer();
    }

    public ShortObjectHashMap<VType> clone() {
        try {
            ShortObjectHashMap cloned = (ShortObjectHashMap)super.clone();
            cloned.keys = (short[])this.keys.clone();
            cloned.values = (Object[])this.values.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ShortObjectCursor<VType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters2) {
        return ShortBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters2);
    }

    public static <VType> ShortObjectHashMap<VType> from(short[] keys, VType[] values2) {
        if (keys.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortObjectHashMap<VType> map2 = new ShortObjectHashMap<VType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map2.put(keys[i], values2[i]);
        }
        return map2;
    }

    protected int hashKey(short key) {
        assert (key != 0);
        return BitMixer.mix(key, this.keyMixer);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(short[] fromKeys, VType[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        short[] keys = this.keys;
        Object[] values2 = this.values;
        int mask = this.mask;
        int from2 = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from2];
        values2[values2.length - 1] = fromValues[from2];
        while (--from2 >= 0) {
            short existing = fromKeys[from2];
            if (existing == 0) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values2[slot] = fromValues[from2];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        short[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new short[arraySize + emptyElementSlot];
            this.values = new Object[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, short pendingKey, VType pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0 && pendingKey != 0);
        short[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        short existing;
        short[] keys = this.keys;
        Object[] values2 = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values2[gapSlot] = values2[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0;
        values2[gapSlot] = null;
        --this.assigned;
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ShortObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCursor();
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    if (ShortObjectHashMap.this.keys[this.slot] != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.value = ShortObjectHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ShortObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ShortObjectHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractObjectCollection<VType> {
        private final ShortObjectHashMap<VType> owner;

        private ValuesContainer() {
            this.owner = ShortObjectHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(VType value2) {
            for (ShortObjectCursor c : this.owner) {
                if (!Objects.equals(c.value, value2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectProcedure<? super VType>> T forEach(T procedure) {
            for (ShortObjectCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super VType>> T forEach(T predicate) {
            for (ShortObjectCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(final VType e) {
            return this.owner.removeAll(new ShortObjectPredicate<VType>(){

                @Override
                public boolean apply(short key, VType value2) {
                    return Objects.equals(value2, e);
                }
            });
        }

        @Override
        public int removeAll(final ObjectPredicate<? super VType> predicate) {
            return this.owner.removeAll(new ShortObjectPredicate<VType>(){

                @Override
                public boolean apply(short key, VType value2) {
                    return predicate.apply(value2);
                }
            });
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ShortObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    short existing = ShortObjectHashMap.this.keys[this.slot];
                    if (existing != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ShortObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final ShortObjectHashMap<VType> owner;

        public KeysContainer() {
            this.owner = ShortObjectHashMap.this;
        }

        @Override
        public boolean contains(short e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ShortProcedure> T forEach(final T procedure) {
            this.owner.forEach(new ShortObjectProcedure<VType>(){

                @Override
                public void apply(short key, VType value2) {
                    procedure.apply(key);
                }
            });
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(final T predicate) {
            this.owner.forEach(new ShortObjectPredicate<VType>(){

                @Override
                public boolean apply(short key, VType value2) {
                    return predicate.apply(key);
                }
            });
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(short e) {
            boolean hasKey = this.owner.containsKey(e);
            if (hasKey) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<ShortObjectCursor<VType>> {
        private final ShortObjectCursor<VType> cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ShortObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortObjectCursor();
        }

        @Override
        protected ShortObjectCursor<VType> fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    short existing = ShortObjectHashMap.this.keys[this.slot];
                    if (existing != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.key = existing;
                        this.cursor.value = ShortObjectHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ShortObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0;
                this.cursor.value = ShortObjectHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ShortObjectCursor)this.done();
        }
    }
}

