/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.ShortBufferVisualizer;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.ShortSet;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ShortHashSet
extends AbstractShortCollection
implements ShortLookupContainer,
ShortSet,
Preallocable,
Cloneable {
    public short[] keys;
    protected int assigned;
    protected int mask;
    protected int keyMixer;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public ShortHashSet() {
        this(4, 0.75);
    }

    public ShortHashSet(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ShortHashSet(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public ShortHashSet(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public ShortHashSet(ShortContainer container2) {
        this(container2.size());
        this.addAll(container2);
    }

    @Override
    public boolean add(short key) {
        short existing;
        if (key == 0) {
            assert (this.keys[this.mask + 1] == 0);
            boolean added = !this.hasEmptyKey;
            this.hasEmptyKey = true;
            return added;
        }
        short[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key);
        } else {
            keys[slot] = key;
        }
        ++this.assigned;
        return true;
    }

    public final int addAll(short ... elements) {
        this.ensureCapacity(elements.length);
        int count2 = 0;
        for (short e : elements) {
            if (!this.add(e)) continue;
            ++count2;
        }
        return count2;
    }

    public int addAll(ShortContainer container2) {
        this.ensureCapacity(container2.size());
        return this.addAll((Iterable<? extends ShortCursor>)container2);
    }

    public int addAll(Iterable<? extends ShortCursor> iterable) {
        int count2 = 0;
        for (ShortCursor shortCursor : iterable) {
            if (!this.add(shortCursor.value)) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public short[] toArray() {
        short[] cloned = new short[this.size()];
        int j = 0;
        if (this.hasEmptyKey) {
            cloned[j++] = 0;
        }
        short[] keys = this.keys;
        int max2 = this.mask;
        for (int slot = 0; slot <= max2; ++slot) {
            short existing = keys[slot];
            if (existing == 0) continue;
            cloned[j++] = existing;
        }
        return cloned;
    }

    public boolean remove(short key) {
        short existing;
        if (key == 0) {
            boolean hadEmptyKey = this.hasEmptyKey;
            this.hasEmptyKey = false;
            return hadEmptyKey;
        }
        short[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int removeAll(short key) {
        return this.remove(key) ? 1 : 0;
    }

    @Override
    public int removeAll(ShortPredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply((short)0)) {
            this.hasEmptyKey = false;
        }
        short[] keys = this.keys;
        int slot = 0;
        int max2 = this.mask;
        while (slot <= max2) {
            short existing = keys[slot];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public boolean contains(short key) {
        short existing;
        if (key == 0) {
            return this.hasEmptyKey;
        }
        short[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, (short)0);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.ensureCapacity(4);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            short[] prevKeys = this.keys;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys);
            }
        }
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        short[] keys = this.keys;
        for (int slot = this.mask; slot >= 0; --slot) {
            short existing = keys[slot];
            if (existing == 0) continue;
            h += BitMixer.mix(existing);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.sameKeys((ShortSet)this.getClass().cast(obj));
    }

    private boolean sameKeys(ShortSet other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (ShortCursor c : other) {
            if (this.contains(c.value)) continue;
            return false;
        }
        return true;
    }

    public ShortHashSet clone() {
        try {
            ShortHashSet cloned = (ShortHashSet)super.clone();
            cloned.keys = (short[])this.keys.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<ShortCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ShortProcedure> T forEach(T procedure) {
        if (this.hasEmptyKey) {
            procedure.apply((short)0);
        }
        short[] keys = this.keys;
        int max2 = this.mask;
        for (int slot = 0; slot <= max2; ++slot) {
            short existing = keys[slot];
            if (existing == 0) continue;
            procedure.apply(existing);
        }
        return procedure;
    }

    @Override
    public <T extends ShortPredicate> T forEach(T predicate) {
        short existing;
        if (this.hasEmptyKey && !predicate.apply((short)0)) {
            return predicate;
        }
        short[] keys = this.keys;
        int max2 = this.mask;
        for (int slot = 0; slot <= max2 && ((existing = keys[slot]) == 0 || predicate.apply(existing)); ++slot) {
        }
        return predicate;
    }

    public static ShortHashSet from(short ... elements) {
        ShortHashSet set2 = new ShortHashSet(elements.length);
        set2.addAll(elements);
        return set2;
    }

    protected int hashKey(short key) {
        assert (key != 0);
        return BitMixer.mix(key, this.keyMixer);
    }

    public int indexOf(short key) {
        short existing;
        int mask = this.mask;
        if (key == 0) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        short[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    public boolean indexExists(int index2) {
        assert (index2 < 0 || index2 >= 0 && index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        return index2 >= 0;
    }

    public short indexGet(int index2) {
        assert (index2 >= 0) : "The index must point at an existing key.";
        assert (index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        return this.keys[index2];
    }

    public short indexReplace(int index2, short equivalentKey) {
        assert (index2 >= 0) : "The index must point at an existing key.";
        assert (index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        assert (equivalentKey == this.keys[index2]);
        short previousValue = this.keys[index2];
        this.keys[index2] = equivalentKey;
        return previousValue;
    }

    public void indexInsert(int index2, short key) {
        assert (index2 < 0) : "The index must not point at an existing key.";
        index2 ^= 0xFFFFFFFF;
        if (key == 0) {
            assert (index2 == this.mask + 1);
            assert (this.keys[index2] == 0);
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index2] == 0);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index2, key);
            } else {
                this.keys[index2] = key;
            }
            ++this.assigned;
        }
    }

    @Override
    public String visualizeKeyDistribution(int characters2) {
        return ShortBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters2);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(short[] fromKeys) {
        assert (HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        short[] keys = this.keys;
        int mask = this.mask;
        int i = fromKeys.length - 1;
        while (--i >= 0) {
            short existing = fromKeys[i];
            if (existing == 0) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        short[] prevKeys = this.keys;
        try {
            int emptyElementSlot = 1;
            this.keys = new short[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.keys == null ? 0 : this.size(), arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, short pendingKey) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0 && pendingKey != 0);
        short[] prevKeys = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        this.rehash(prevKeys);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        short existing;
        short[] keys = this.keys;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0;
        --this.assigned;
    }

    protected final class EntryIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ShortHashSet.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    short existing = ShortHashSet.this.keys[this.slot];
                    if (existing != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ShortHashSet.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }
}

