/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.ShortByteHashMap;

public class ShortByteScatterMap
extends ShortByteHashMap {
    public ShortByteScatterMap() {
        this(4);
    }

    public ShortByteScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ShortByteScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(short key) {
        return BitMixer.mixPhi(key);
    }

    public static ShortByteScatterMap from(short[] keys, byte[] values2) {
        if (keys.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ShortByteScatterMap map2 = new ShortByteScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map2.put(keys[i], values2[i]);
        }
        return map2;
    }
}

