/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.ObjectObjectHashMap;

public class ObjectObjectScatterMap<KType, VType>
extends ObjectObjectHashMap<KType, VType> {
    public ObjectObjectScatterMap() {
        this(4);
    }

    public ObjectObjectScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectObjectScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(KType key) {
        return BitMixer.mixPhi(key);
    }

    public static <KType, VType> ObjectObjectScatterMap<KType, VType> from(KType[] keys, VType[] values2) {
        if (keys.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectObjectScatterMap<KType, VType> map2 = new ObjectObjectScatterMap<KType, VType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map2.put(keys[i], values2[i]);
        }
        return map2;
    }
}

