/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.ObjectDoubleHashMap;

public class ObjectDoubleScatterMap<KType>
extends ObjectDoubleHashMap<KType> {
    public ObjectDoubleScatterMap() {
        this(4);
    }

    public ObjectDoubleScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectDoubleScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(KType key) {
        return BitMixer.mixPhi(key);
    }

    public static <KType> ObjectDoubleScatterMap<KType> from(KType[] keys, double[] values2) {
        if (keys.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectDoubleScatterMap<KType> map2 = new ObjectDoubleScatterMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map2.put(keys[i], values2[i]);
        }
        return map2;
    }
}

