/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.ObjectCharAssociativeContainer;
import com.carrotsearch.hppc.ObjectCharHashMap;

public class ObjectCharIdentityHashMap<KType>
extends ObjectCharHashMap<KType> {
    public ObjectCharIdentityHashMap() {
        this(4);
    }

    public ObjectCharIdentityHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectCharIdentityHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.randomized());
    }

    public ObjectCharIdentityHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public ObjectCharIdentityHashMap(ObjectCharAssociativeContainer<? extends KType> container2) {
        this(container2.size());
        this.putAll(container2);
    }

    @Override
    public int hashKey(KType key) {
        assert (key != null);
        return BitMixer.mix(System.identityHashCode(key), this.keyMixer);
    }

    @Override
    public boolean equals(Object v1, Object v2) {
        return v1 == v2;
    }

    public static <KType> ObjectCharIdentityHashMap<KType> from(KType[] keys, char[] values2) {
        if (keys.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectCharIdentityHashMap<KType> map2 = new ObjectCharIdentityHashMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map2.put(keys[i], values2[i]);
        }
        return map2;
    }
}

