/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.CharCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.ObjectBufferVisualizer;
import com.carrotsearch.hppc.ObjectCharAssociativeContainer;
import com.carrotsearch.hppc.ObjectCharMap;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.ObjectCharCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.ObjectCharPredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.ObjectCharProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ObjectCharHashMap<KType>
implements ObjectCharMap<KType>,
Preallocable,
Cloneable {
    public Object[] keys;
    public char[] values;
    protected int keyMixer;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public ObjectCharHashMap() {
        this(4);
    }

    public ObjectCharHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectCharHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public ObjectCharHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public ObjectCharHashMap(ObjectCharAssociativeContainer<? extends KType> container2) {
        this(container2.size());
        this.putAll(container2);
    }

    @Override
    public char put(KType key, char value2) {
        Object existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == null) {
            this.hasEmptyKey = true;
            char previousValue = this.values[mask + 1];
            this.values[mask + 1] = value2;
            return previousValue;
        }
        Object[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(existing, key)) {
                char previousValue = this.values[slot];
                this.values[slot] = value2;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value2);
        } else {
            keys[slot] = key;
            this.values[slot] = value2;
        }
        ++this.assigned;
        return '\u0000';
    }

    @Override
    public int putAll(ObjectCharAssociativeContainer<? extends KType> container2) {
        int count2 = this.size();
        for (ObjectCharCursor<KType> objectCharCursor : container2) {
            this.put(objectCharCursor.key, objectCharCursor.value);
        }
        return this.size() - count2;
    }

    @Override
    public int putAll(Iterable<? extends ObjectCharCursor<? extends KType>> iterable) {
        int count2 = this.size();
        for (ObjectCharCursor<KType> objectCharCursor : iterable) {
            this.put(objectCharCursor.key, objectCharCursor.value);
        }
        return this.size() - count2;
    }

    public boolean putIfAbsent(KType key, char value2) {
        if (!this.containsKey(key)) {
            this.put(key, value2);
            return true;
        }
        return false;
    }

    @Override
    public char putOrAdd(KType key, char putValue, char incrementValue) {
        assert (this.assigned < this.mask + 1);
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue = (char)(putValue + incrementValue);
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public char addTo(KType key, char incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    @Override
    public char remove(KType key) {
        Object existing;
        int mask = this.mask;
        if (key == null) {
            this.hasEmptyKey = false;
            char previousValue = this.values[mask + 1];
            this.values[mask + 1] = '\u0000';
            return previousValue;
        }
        Object[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(existing, key)) {
                char previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return '\u0000';
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int removeAll(ObjectContainer<? super KType> other) {
        int before = this.size();
        if (other.size() >= this.size() && other instanceof ObjectLookupContainer) {
            void var4_6;
            if (this.hasEmptyKey && other.contains(null)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = '\u0000';
            }
            Object[] keys = this.keys;
            boolean bl = false;
            int max2 = this.mask;
            while (var4_6 <= max2) {
                Object existing = keys[var4_6];
                if (existing != null && other.contains(existing)) {
                    this.shiftConflictingKeys((int)var4_6);
                    continue;
                }
                ++var4_6;
            }
        } else {
            for (ObjectCursor<Object> objectCursor : other) {
                this.remove(objectCursor.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ObjectCharPredicate<? super KType> predicate) {
        int before = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply(null, this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = '\u0000';
        }
        Object[] keys = this.keys;
        char[] values2 = this.values;
        int slot = 0;
        while (slot <= mask) {
            Object existing = keys[slot];
            if (existing != null && predicate.apply(existing, values2[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply(null)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = '\u0000';
        }
        Object[] keys = this.keys;
        int slot = 0;
        int max2 = this.mask;
        while (slot <= max2) {
            Object existing = keys[slot];
            if (existing != null && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public char get(KType key) {
        Object existing;
        if (key == null) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : (char)'\u0000';
        }
        Object[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(existing, key)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return '\u0000';
    }

    @Override
    public char getOrDefault(KType key, char defaultValue2) {
        Object existing;
        if (key == null) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue2;
        }
        Object[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(existing, key)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue2;
    }

    @Override
    public boolean containsKey(KType key) {
        Object existing;
        if (key == null) {
            return this.hasEmptyKey;
        }
        Object[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(existing, key)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(KType key) {
        Object existing;
        int mask = this.mask;
        if (key == null) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        Object[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != null) {
            if (this.equals(existing, key)) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index2) {
        assert (index2 < 0 || index2 >= 0 && index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        return index2 >= 0;
    }

    @Override
    public char indexGet(int index2) {
        assert (index2 >= 0) : "The index must point at an existing key.";
        assert (index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        return this.values[index2];
    }

    @Override
    public char indexReplace(int index2, char newValue) {
        assert (index2 >= 0) : "The index must point at an existing key.";
        assert (index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        char previousValue = this.values[index2];
        this.values[index2] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index2, KType key, char value2) {
        assert (index2 < 0) : "The index must not point at an existing key.";
        index2 ^= 0xFFFFFFFF;
        if (key == null) {
            assert (index2 == this.mask + 1);
            this.values[index2] = value2;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index2] == null);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index2, key, value2);
            } else {
                this.keys[index2] = key;
                this.values[index2] = value2;
            }
            ++this.assigned;
        }
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, null);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (ObjectCharCursor<KType> c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((ObjectCharHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(ObjectCharHashMap<?> other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (ObjectCharCursor<?> c : other) {
            Object key = c.key;
            if (this.containsKey(key) && this.get(key) == c.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            Object[] prevKeys = this.keys;
            char[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public Iterator<ObjectCharCursor<KType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends ObjectCharProcedure<? super KType>> T forEach(T procedure) {
        Object[] keys = this.keys;
        char[] values2 = this.values;
        if (this.hasEmptyKey) {
            procedure.apply(null, values2[this.mask + 1]);
        }
        int max2 = this.mask;
        for (int slot = 0; slot <= max2; ++slot) {
            if (keys[slot] == null) continue;
            procedure.apply((Object)keys[slot], values2[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends ObjectCharPredicate<? super KType>> T forEach(T predicate) {
        Object[] keys = this.keys;
        char[] values2 = this.values;
        if (this.hasEmptyKey && !predicate.apply(null, values2[this.mask + 1])) {
            return predicate;
        }
        int max2 = this.mask;
        for (int slot = 0; slot <= max2 && (keys[slot] == null || predicate.apply((Object)keys[slot], values2[slot])); ++slot) {
        }
        return predicate;
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public CharCollection values() {
        return new ValuesContainer();
    }

    public ObjectCharHashMap<KType> clone() {
        try {
            ObjectCharHashMap cloned = (ObjectCharHashMap)super.clone();
            cloned.keys = (Object[])this.keys.clone();
            cloned.values = (char[])this.values.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (ObjectCharCursor<KType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters2) {
        return ObjectBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters2);
    }

    public static <KType> ObjectCharHashMap<KType> from(KType[] keys, char[] values2) {
        if (keys.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectCharHashMap<KType> map2 = new ObjectCharHashMap<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map2.put(keys[i], values2[i]);
        }
        return map2;
    }

    protected int hashKey(KType key) {
        assert (key != null);
        return BitMixer.mix(key, this.keyMixer);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(KType[] fromKeys, char[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        Object[] keys = this.keys;
        char[] values2 = this.values;
        int mask = this.mask;
        int from2 = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from2];
        values2[values2.length - 1] = fromValues[from2];
        while (--from2 >= 0) {
            KType existing = fromKeys[from2];
            if (existing == null) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != null) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values2[slot] = fromValues[from2];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        Object[] prevKeys = this.keys;
        char[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new Object[arraySize + emptyElementSlot];
            this.values = new char[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, KType pendingKey, char pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == null && pendingKey != null);
        Object[] prevKeys = this.keys;
        char[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        Object existing;
        Object[] keys = this.keys;
        char[] values2 = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != null) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values2[gapSlot] = values2[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = null;
        values2[gapSlot] = '\u0000';
        --this.assigned;
    }

    protected boolean equals(Object v1, Object v2) {
        return v1 == v2 || v1 != null && v1.equals(v2);
    }

    private final class ValuesIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ObjectCharHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharCursor();
        }

        @Override
        protected CharCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    if (ObjectCharHashMap.this.keys[this.slot] != null) {
                        this.cursor.index = this.slot;
                        this.cursor.value = ObjectCharHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ObjectCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ObjectCharHashMap.this.values[this.max];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractCharCollection {
        private final ObjectCharHashMap<KType> owner;

        private ValuesContainer() {
            this.owner = ObjectCharHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(char value2) {
            for (ObjectCharCursor c : this.owner) {
                if (c.value != value2) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            for (ObjectCharCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            for (ObjectCharCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(final char e) {
            return this.owner.removeAll(new ObjectCharPredicate<KType>(){

                @Override
                public boolean apply(KType key, char value2) {
                    return value2 == e;
                }
            });
        }

        @Override
        public int removeAll(final CharPredicate predicate) {
            return this.owner.removeAll(new ObjectCharPredicate<KType>(){

                @Override
                public boolean apply(KType key, char value2) {
                    return predicate.apply(value2);
                }
            });
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ObjectCharHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCursor();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    Object existing = ObjectCharHashMap.this.keys[this.slot];
                    if (existing != null) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ObjectCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = null;
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractObjectCollection<KType>
    implements ObjectLookupContainer<KType> {
        private final ObjectCharHashMap<KType> owner;

        public KeysContainer() {
            this.owner = ObjectCharHashMap.this;
        }

        @Override
        public boolean contains(KType e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(final T procedure) {
            this.owner.forEach(new ObjectCharProcedure<KType>(){

                @Override
                public void apply(KType key, char value2) {
                    procedure.apply(key);
                }
            });
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(final T predicate) {
            this.owner.forEach(new ObjectCharPredicate<KType>(){

                @Override
                public boolean apply(KType key, char value2) {
                    return predicate.apply(key);
                }
            });
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<KType>> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(KType e) {
            boolean hasKey = this.owner.containsKey(e);
            if (hasKey) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<ObjectCharCursor<KType>> {
        private final ObjectCharCursor<KType> cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ObjectCharHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCharCursor();
        }

        @Override
        protected ObjectCharCursor<KType> fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    Object existing = ObjectCharHashMap.this.keys[this.slot];
                    if (existing != null) {
                        this.cursor.index = this.slot;
                        this.cursor.key = existing;
                        this.cursor.value = ObjectCharHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && ObjectCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = null;
                this.cursor.value = ObjectCharHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ObjectCharCursor)this.done();
        }
    }
}

