/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectIndexedContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ObjectArrayList<KType>
extends AbstractObjectCollection<KType>
implements ObjectIndexedContainer<KType>,
Preallocable,
Cloneable {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public Object[] buffer = EMPTY_ARRAY;
    public int elementsCount;
    protected final ArraySizingStrategy resizer;

    public ObjectArrayList() {
        this(4);
    }

    public ObjectArrayList(int expectedElements) {
        this(expectedElements, new BoundedProportionalArraySizingStrategy());
    }

    public ObjectArrayList(int expectedElements, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureCapacity(expectedElements);
    }

    public ObjectArrayList(ObjectContainer<? extends KType> container2) {
        this(container2.size());
        this.addAll(container2);
    }

    @Override
    public void add(KType e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(KType e1, KType e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void add(KType[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    @Override
    @SafeVarargs
    public final void add(KType ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int addAll(ObjectContainer<? extends KType> container2) {
        int size2 = container2.size();
        this.ensureBufferSpace(size2);
        for (ObjectCursor<KType> objectCursor : container2) {
            this.add((KType)objectCursor.value);
        }
        return size2;
    }

    public int addAll(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        int size2 = 0;
        for (ObjectCursor<KType> objectCursor : iterable) {
            this.add((KType)objectCursor.value);
            ++size2;
        }
        return size2;
    }

    @Override
    public void insert(int index2, KType e1) {
        assert (index2 >= 0 && index2 <= this.size()) : "Index " + index2 + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index2, this.buffer, index2 + 1, this.elementsCount - index2);
        this.buffer[index2] = e1;
        ++this.elementsCount;
    }

    @Override
    public KType get(int index2) {
        assert (index2 >= 0 && index2 < this.size()) : "Index " + index2 + " out of bounds [" + 0 + ", " + this.size() + ").";
        return (KType)this.buffer[index2];
    }

    @Override
    public KType set(int index2, KType e1) {
        assert (index2 >= 0 && index2 < this.size()) : "Index " + index2 + " out of bounds [" + 0 + ", " + this.size() + ").";
        Object v = this.buffer[index2];
        this.buffer[index2] = e1;
        return (KType)v;
    }

    @Override
    public KType remove(int index2) {
        assert (index2 >= 0 && index2 < this.size()) : "Index " + index2 + " out of bounds [" + 0 + ", " + this.size() + ").";
        Object v = this.buffer[index2];
        if (index2 + 1 < this.elementsCount) {
            System.arraycopy(this.buffer, index2 + 1, this.buffer, index2, this.elementsCount - index2 - 1);
        }
        --this.elementsCount;
        this.buffer[this.elementsCount] = null;
        return (KType)v;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count2 = toIndex - fromIndex;
        this.elementsCount -= count2;
        Arrays.fill(this.buffer, this.elementsCount, this.elementsCount + count2, null);
    }

    @Override
    public int removeFirst(KType e1) {
        int index2 = this.indexOf(e1);
        if (index2 >= 0) {
            this.remove(index2);
        }
        return index2;
    }

    @Override
    public int removeLast(KType e1) {
        int index2 = this.lastIndexOf(e1);
        if (index2 >= 0) {
            this.remove(index2);
        }
        return index2;
    }

    @Override
    public int removeAll(KType e1) {
        int to2 = 0;
        for (int from2 = 0; from2 < this.elementsCount; ++from2) {
            if (this.equals(this.buffer[from2], e1)) {
                this.buffer[from2] = null;
                continue;
            }
            if (to2 != from2) {
                this.buffer[to2] = this.buffer[from2];
                this.buffer[from2] = null;
            }
            ++to2;
        }
        int deleted = this.elementsCount - to2;
        this.elementsCount = to2;
        return deleted;
    }

    @Override
    public boolean contains(KType e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public int indexOf(KType e1) {
        for (int i = 0; i < this.elementsCount; ++i) {
            if (!this.equals(this.buffer[i], e1)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(KType e1) {
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (!this.equals(this.buffer[i], e1)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.elementsCount == 0;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (expectedElements > bufferLen) {
            this.ensureBufferSpace(expectedElements - this.size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount + expectedAdditions > bufferLen) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            assert (newSize >= this.elementsCount + expectedAdditions) : "Resizer failed to return sensible new size: " + newSize + " <= " + (this.elementsCount + expectedAdditions);
            this.buffer = Arrays.copyOf(this.buffer, newSize);
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize < this.elementsCount) {
                Arrays.fill(this.buffer, newSize, this.elementsCount, null);
            } else {
                Arrays.fill(this.buffer, this.elementsCount, newSize, null);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    @Override
    public void clear() {
        Arrays.fill(this.buffer, 0, this.elementsCount, null);
        this.elementsCount = 0;
    }

    @Override
    public void release() {
        this.buffer = EMPTY_ARRAY;
        this.elementsCount = 0;
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.buffer, this.elementsCount);
    }

    public ObjectArrayList<KType> clone() {
        try {
            ObjectArrayList cloned = (ObjectArrayList)super.clone();
            cloned.buffer = (Object[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int h = 1;
        int max2 = this.elementsCount;
        for (int i = 0; i < max2; ++i) {
            h = 31 * h + BitMixer.mix(this.buffer[i]);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((ObjectArrayList)this.getClass().cast(obj));
    }

    protected boolean equalElements(ObjectArrayList<?> other) {
        int max2 = this.size();
        if (other.size() != max2) {
            return false;
        }
        for (int i = 0; i < max2; ++i) {
            if (this.equals(other.get(i), this.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<ObjectCursor<KType>> iterator() {
        return new ValueIterator<Object>(this.buffer, this.size());
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
        return this.forEach(procedure, 0, this.size());
    }

    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        Object[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex; ++i) {
            procedure.apply((Object)buffer[i]);
        }
        return procedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int from2;
        Object[] buffer = this.buffer;
        int elementsCount = this.elementsCount;
        int to2 = 0;
        try {
            for (from2 = 0; from2 < elementsCount; ++from2) {
                if (predicate.apply(buffer[from2])) {
                    buffer[from2] = null;
                    continue;
                }
                if (to2 != from2) {
                    buffer[to2] = buffer[from2];
                    buffer[from2] = null;
                }
                ++to2;
            }
        }
        finally {
            while (from2 < elementsCount) {
                if (to2 != from2) {
                    buffer[to2] = buffer[from2];
                    buffer[from2] = null;
                }
                ++to2;
                ++from2;
            }
            this.elementsCount = to2;
        }
        return elementsCount - to2;
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
        return this.forEach(predicate, 0, this.size());
    }

    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate, int fromIndex, int toIndex) {
        assert (fromIndex >= 0 && fromIndex <= this.size()) : "Index " + fromIndex + " out of bounds [" + 0 + ", " + this.size() + ").";
        assert (toIndex >= 0 && toIndex <= this.size()) : "Index " + toIndex + " out of bounds [" + 0 + ", " + this.size() + "].";
        assert (fromIndex <= toIndex) : "fromIndex must be <= toIndex: " + fromIndex + ", " + toIndex;
        Object[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex && predicate.apply((Object)buffer[i]); ++i) {
        }
        return predicate;
    }

    @SafeVarargs
    public static <KType> ObjectArrayList<KType> from(KType ... elements) {
        ObjectArrayList<KType> list2 = new ObjectArrayList<KType>(elements.length);
        list2.add(elements);
        return list2;
    }

    static final class ValueIterator<KType>
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private final KType[] buffer;
        private final int size;

        public ValueIterator(KType[] buffer, int size2) {
            this.cursor.index = -1;
            this.size = size2;
            this.buffer = buffer;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (ObjectCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }
    }
}

