/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.ObjectArrayList;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.ObjectDeque;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ObjectArrayDeque<KType>
extends AbstractObjectCollection<KType>
implements ObjectDeque<KType>,
Preallocable,
Cloneable {
    public Object[] buffer = ObjectArrayList.EMPTY_ARRAY;
    public int head;
    public int tail;
    protected final ArraySizingStrategy resizer;

    public ObjectArrayDeque() {
        this(4);
    }

    public ObjectArrayDeque(int expectedElements) {
        this(expectedElements, new BoundedProportionalArraySizingStrategy());
    }

    public ObjectArrayDeque(int expectedElements, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureCapacity(expectedElements);
    }

    public ObjectArrayDeque(ObjectContainer<? extends KType> container2) {
        this(container2.size());
        this.addLast(container2);
    }

    @Override
    public void addFirst(KType e1) {
        int h = ObjectArrayDeque.oneLeft(this.head, this.buffer.length);
        if (h == this.tail) {
            this.ensureBufferSpace(1);
            h = ObjectArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        this.head = h;
        this.buffer[this.head] = e1;
    }

    @Override
    @SafeVarargs
    public final void addFirst(KType ... elements) {
        this.ensureBufferSpace(elements.length);
        for (KType k : elements) {
            this.addFirst(k);
        }
    }

    public int addFirst(ObjectContainer<? extends KType> container2) {
        int size2 = container2.size();
        this.ensureBufferSpace(size2);
        for (ObjectCursor<KType> objectCursor : container2) {
            this.addFirst((KType)objectCursor.value);
        }
        return size2;
    }

    public int addFirst(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        int size2 = 0;
        for (ObjectCursor<KType> objectCursor : iterable) {
            this.addFirst((KType)objectCursor.value);
            ++size2;
        }
        return size2;
    }

    @Override
    public void addLast(KType e1) {
        int t = ObjectArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == t) {
            this.ensureBufferSpace(1);
            t = ObjectArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = e1;
        this.tail = t;
    }

    @Override
    @SafeVarargs
    public final void addLast(KType ... elements) {
        this.ensureBufferSpace(1);
        for (KType k : elements) {
            this.addLast(k);
        }
    }

    public int addLast(ObjectContainer<? extends KType> container2) {
        int size2 = container2.size();
        this.ensureBufferSpace(size2);
        for (ObjectCursor<KType> objectCursor : container2) {
            this.addLast((KType)objectCursor.value);
        }
        return size2;
    }

    public int addLast(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        int size2 = 0;
        for (ObjectCursor<KType> objectCursor : iterable) {
            this.addLast((KType)objectCursor.value);
            ++size2;
        }
        return size2;
    }

    @Override
    public KType removeFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        Object result2 = this.buffer[this.head];
        this.buffer[this.head] = null;
        this.head = ObjectArrayDeque.oneRight(this.head, this.buffer.length);
        return (KType)result2;
    }

    @Override
    public KType removeLast() {
        assert (this.size() > 0) : "The deque is empty.";
        this.tail = ObjectArrayDeque.oneLeft(this.tail, this.buffer.length);
        Object result2 = this.buffer[this.tail];
        this.buffer[this.tail] = null;
        return (KType)result2;
    }

    @Override
    public KType getFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        return (KType)this.buffer[this.head];
    }

    @Override
    public KType getLast() {
        assert (this.size() > 0) : "The deque is empty.";
        return (KType)this.buffer[ObjectArrayDeque.oneLeft(this.tail, this.buffer.length)];
    }

    @Override
    public int removeFirst(KType e1) {
        int index2 = this.bufferIndexOf(e1);
        if (index2 >= 0) {
            this.removeAtBufferIndex(index2);
        }
        return index2;
    }

    public int bufferIndexOf(KType e1) {
        int last2 = this.tail;
        int bufLen = this.buffer.length;
        int i = this.head;
        while (i != last2) {
            if (this.equals(this.buffer[i], e1)) {
                return i;
            }
            i = ObjectArrayDeque.oneRight(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeLast(KType e1) {
        int index2 = this.lastBufferIndexOf(e1);
        if (index2 >= 0) {
            this.removeAtBufferIndex(index2);
        }
        return index2;
    }

    public int lastBufferIndexOf(KType e1) {
        int bufLen = this.buffer.length;
        int last2 = ObjectArrayDeque.oneLeft(this.head, bufLen);
        int i = ObjectArrayDeque.oneLeft(this.tail, bufLen);
        while (i != last2) {
            if (this.equals(this.buffer[i], e1)) {
                return i;
            }
            i = ObjectArrayDeque.oneLeft(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeAll(KType e1) {
        int to2;
        int removed = 0;
        int last2 = this.tail;
        int bufLen = this.buffer.length;
        int from2 = to2 = this.head;
        while (from2 != last2) {
            if (this.equals(this.buffer[from2], e1)) {
                this.buffer[from2] = null;
                ++removed;
            } else {
                if (to2 != from2) {
                    this.buffer[to2] = this.buffer[from2];
                    this.buffer[from2] = null;
                }
                to2 = ObjectArrayDeque.oneRight(to2, bufLen);
            }
            from2 = ObjectArrayDeque.oneRight(from2, bufLen);
        }
        this.tail = to2;
        return removed;
    }

    public void removeAtBufferIndex(int index2) {
        int rightChunk;
        assert (this.head > this.tail ? index2 >= this.head || index2 < this.tail : index2 >= this.head && index2 < this.tail) : "Index out of range (head=" + this.head + ", tail=" + this.tail + ", index=" + index2 + ").";
        Object[] buffer = this.buffer;
        int bufLen = buffer.length;
        int lastIndex = bufLen - 1;
        int head2 = this.head;
        int tail = this.tail;
        int leftChunk = Math.abs(index2 - head2) % bufLen;
        if (leftChunk < (rightChunk = Math.abs(tail - index2) % bufLen)) {
            if (index2 >= head2) {
                System.arraycopy(buffer, head2, buffer, head2 + 1, leftChunk);
            } else {
                System.arraycopy(buffer, 0, buffer, 1, index2);
                buffer[0] = buffer[lastIndex];
                System.arraycopy(buffer, head2, buffer, head2 + 1, lastIndex - head2);
            }
            buffer[head2] = null;
            this.head = ObjectArrayDeque.oneRight(head2, bufLen);
        } else {
            if (index2 < tail) {
                System.arraycopy(buffer, index2 + 1, buffer, index2, rightChunk);
            } else {
                System.arraycopy(buffer, index2 + 1, buffer, index2, lastIndex - index2);
                buffer[lastIndex] = buffer[0];
                System.arraycopy(buffer, 1, buffer, 0, tail);
            }
            buffer[tail] = null;
            this.tail = ObjectArrayDeque.oneLeft(tail, bufLen);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.tail - this.head + this.buffer.length;
    }

    @Override
    public void clear() {
        if (this.head < this.tail) {
            Arrays.fill(this.buffer, this.head, this.tail, null);
        } else {
            Arrays.fill(this.buffer, 0, this.tail, null);
            Arrays.fill(this.buffer, this.head, this.buffer.length, null);
        }
        this.tail = 0;
        this.head = 0;
    }

    @Override
    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = ObjectArrayList.EMPTY_ARRAY;
        this.ensureBufferSpace(0);
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        this.ensureBufferSpace(expectedElements - this.size());
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen = this.buffer.length;
        int elementsCount = this.size();
        if (elementsCount + expectedAdditions >= bufferLen) {
            boolean emptySlot = true;
            int newSize = this.resizer.grow(bufferLen, elementsCount + 1, expectedAdditions);
            assert (newSize >= elementsCount + expectedAdditions + 1) : "Resizer failed to return sensible new size: " + newSize + " <= " + (elementsCount + expectedAdditions);
            try {
                Object[] newBuffer = new Object[newSize];
                if (bufferLen > 0) {
                    this.toArray(newBuffer);
                    this.tail = elementsCount;
                    this.head = 0;
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate new buffers: %,d -> %,d", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    @Override
    public Object[] toArray() {
        int size2 = this.size();
        return this.toArray(new Object[size2]);
    }

    public KType[] toArray(KType[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        if (this.head < this.tail) {
            System.arraycopy(this.buffer, this.head, target, 0, this.size());
        } else if (this.head > this.tail) {
            int rightCount = this.buffer.length - this.head;
            System.arraycopy(this.buffer, this.head, target, 0, rightCount);
            System.arraycopy(this.buffer, 0, target, rightCount, this.tail);
        }
        return target;
    }

    public ObjectArrayDeque<KType> clone() {
        try {
            ObjectArrayDeque cloned = (ObjectArrayDeque)super.clone();
            cloned.buffer = (Object[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected static int oneLeft(int index2, int modulus) {
        if (index2 >= 1) {
            return index2 - 1;
        }
        return modulus - 1;
    }

    protected static int oneRight(int index2, int modulus) {
        if (index2 + 1 == modulus) {
            return 0;
        }
        return index2 + 1;
    }

    @Override
    public Iterator<ObjectCursor<KType>> iterator() {
        return new ValueIterator();
    }

    @Override
    public Iterator<ObjectCursor<KType>> descendingIterator() {
        return new DescendingValueIterator();
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
        this.forEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void forEach(ObjectProcedure<? super KType> procedure, int fromIndex, int toIndex) {
        Object[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            procedure.apply(buffer[i]);
            i = ObjectArrayDeque.oneRight(i, buffer.length);
        }
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        Object[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex && predicate.apply((Object)buffer[i])) {
            i = ObjectArrayDeque.oneRight(i, buffer.length);
        }
        return predicate;
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T descendingForEach(T procedure) {
        this.descendingForEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void descendingForEach(ObjectProcedure<? super KType> procedure, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        Object[] buffer = this.buffer;
        int i = toIndex;
        do {
            i = ObjectArrayDeque.oneLeft(i, buffer.length);
            procedure.apply(buffer[i]);
        } while (i != fromIndex);
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T descendingForEach(T predicate) {
        this.descendingForEach(predicate, this.head, this.tail);
        return predicate;
    }

    private void descendingForEach(ObjectPredicate<? super KType> predicate, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        Object[] buffer = this.buffer;
        int i = toIndex;
        while (predicate.apply(buffer[i = ObjectArrayDeque.oneLeft(i, buffer.length)]) && i != fromIndex) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        int to2;
        Object[] buffer = this.buffer;
        int last2 = this.tail;
        int bufLen = buffer.length;
        int removed = 0;
        int from2 = to2 = this.head;
        try {
            from2 = to2 = this.head;
            while (from2 != last2) {
                if (predicate.apply(buffer[from2])) {
                    buffer[from2] = null;
                    ++removed;
                } else {
                    if (to2 != from2) {
                        buffer[to2] = buffer[from2];
                        buffer[from2] = null;
                    }
                    to2 = ObjectArrayDeque.oneRight(to2, bufLen);
                }
                from2 = ObjectArrayDeque.oneRight(from2, bufLen);
            }
        }
        finally {
            while (from2 != last2) {
                if (to2 != from2) {
                    buffer[to2] = buffer[from2];
                    buffer[from2] = null;
                }
                to2 = ObjectArrayDeque.oneRight(to2, bufLen);
                from2 = ObjectArrayDeque.oneRight(from2, bufLen);
            }
            this.tail = to2;
        }
        return removed;
    }

    @Override
    public boolean contains(KType e) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        Object[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            if (this.equals(buffer[i], e)) {
                return true;
            }
            i = ObjectArrayDeque.oneRight(i, buffer.length);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        int fromIndex = this.head;
        int toIndex = this.tail;
        Object[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            h = 31 * h + BitMixer.mix(this.buffer[i]);
            i = ObjectArrayDeque.oneRight(i, buffer.length);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((ObjectArrayDeque)this.getClass().cast(obj));
    }

    protected boolean equalElements(ObjectArrayDeque<?> other) {
        int max2 = this.size();
        if (other.size() != max2) {
            return false;
        }
        Iterator<ObjectCursor<KType>> i1 = this.iterator();
        Iterator<ObjectCursor<?>> i2 = other.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (this.equals(i2.next().value, i1.next().value)) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    @SafeVarargs
    public static <KType> ObjectArrayDeque<KType> from(KType ... elements) {
        ObjectArrayDeque<KType> coll = new ObjectArrayDeque<KType>(elements.length);
        coll.addLast(elements);
        return coll;
    }

    private final class DescendingValueIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private int remaining;

        public DescendingValueIterator() {
            this.cursor.index = ObjectArrayDeque.this.tail;
            this.remaining = ObjectArrayDeque.this.size();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.remaining == 0) {
                return (ObjectCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = ObjectArrayDeque.oneLeft(this.cursor.index, ObjectArrayDeque.this.buffer.length);
            this.cursor.value = ObjectArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }

    private final class ValueIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        private final ObjectCursor<KType> cursor = new ObjectCursor();
        private int remaining;

        public ValueIterator() {
            this.cursor.index = ObjectArrayDeque.oneLeft(ObjectArrayDeque.this.head, ObjectArrayDeque.this.buffer.length);
            this.remaining = ObjectArrayDeque.this.size();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.remaining == 0) {
                return (ObjectCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = ObjectArrayDeque.oneRight(this.cursor.index, ObjectArrayDeque.this.buffer.length);
            this.cursor.value = ObjectArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }
}

