/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.LongBufferVisualizer;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.LongObjectAssociativeContainer;
import com.carrotsearch.hppc.LongObjectMap;
import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.LongObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.LongObjectPredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.procedures.LongObjectProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public class LongObjectHashMap<VType>
implements LongObjectMap<VType>,
Preallocable,
Cloneable {
    public long[] keys;
    public Object[] values;
    protected int keyMixer;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public LongObjectHashMap() {
        this(4);
    }

    public LongObjectHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public LongObjectHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public LongObjectHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public LongObjectHashMap(LongObjectAssociativeContainer<? extends VType> container2) {
        this(container2.size());
        this.putAll(container2);
    }

    @Override
    public VType put(long key, VType value2) {
        long existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == 0L) {
            this.hasEmptyKey = true;
            Object previousValue = this.values[mask + 1];
            this.values[mask + 1] = value2;
            return (VType)previousValue;
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                Object previousValue = this.values[slot];
                this.values[slot] = value2;
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value2);
        } else {
            keys[slot] = key;
            this.values[slot] = value2;
        }
        ++this.assigned;
        return null;
    }

    @Override
    public int putAll(LongObjectAssociativeContainer<? extends VType> container2) {
        int count2 = this.size();
        for (LongObjectCursor<VType> longObjectCursor : container2) {
            this.put(longObjectCursor.key, longObjectCursor.value);
        }
        return this.size() - count2;
    }

    @Override
    public int putAll(Iterable<? extends LongObjectCursor<? extends VType>> iterable) {
        int count2 = this.size();
        for (LongObjectCursor<VType> longObjectCursor : iterable) {
            this.put(longObjectCursor.key, longObjectCursor.value);
        }
        return this.size() - count2;
    }

    public boolean putIfAbsent(long key, VType value2) {
        if (!this.containsKey(key)) {
            this.put(key, value2);
            return true;
        }
        return false;
    }

    @Override
    public VType remove(long key) {
        long existing;
        int mask = this.mask;
        if (key == 0L) {
            this.hasEmptyKey = false;
            Object previousValue = this.values[mask + 1];
            this.values[mask + 1] = null;
            return (VType)previousValue;
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                Object previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return (VType)previousValue;
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    @Override
    public int removeAll(LongContainer other) {
        int before = this.size();
        if (other.size() >= this.size() && other instanceof LongLookupContainer) {
            if (this.hasEmptyKey && other.contains(0L)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = null;
            }
            long[] keys = this.keys;
            int slot = 0;
            int max2 = this.mask;
            while (slot <= max2) {
                long existing = keys[slot];
                if (existing != 0L && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (LongCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(LongObjectPredicate<? super VType> predicate) {
        int before = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply(0L, this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = null;
        }
        long[] keys = this.keys;
        Object[] values2 = this.values;
        int slot = 0;
        while (slot <= mask) {
            long existing = keys[slot];
            if (existing != 0L && predicate.apply(existing, values2[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(LongPredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply(0L)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = null;
        }
        long[] keys = this.keys;
        int slot = 0;
        int max2 = this.mask;
        while (slot <= max2) {
            long existing = keys[slot];
            if (existing != 0L && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public VType get(long key) {
        long existing;
        if (key == 0L) {
            return (VType)(this.hasEmptyKey ? this.values[this.mask + 1] : null);
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return null;
    }

    @Override
    public VType getOrDefault(long key, VType defaultValue2) {
        long existing;
        if (key == 0L) {
            return (VType)(this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue2);
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                return (VType)this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue2;
    }

    @Override
    public boolean containsKey(long key) {
        long existing;
        if (key == 0L) {
            return this.hasEmptyKey;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(long key) {
        long existing;
        int mask = this.mask;
        if (key == 0L) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index2) {
        assert (index2 < 0 || index2 >= 0 && index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        return index2 >= 0;
    }

    @Override
    public VType indexGet(int index2) {
        assert (index2 >= 0) : "The index must point at an existing key.";
        assert (index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        return (VType)this.values[index2];
    }

    @Override
    public VType indexReplace(int index2, VType newValue) {
        assert (index2 >= 0) : "The index must point at an existing key.";
        assert (index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        Object previousValue = this.values[index2];
        this.values[index2] = newValue;
        return (VType)previousValue;
    }

    @Override
    public void indexInsert(int index2, long key, VType value2) {
        assert (index2 < 0) : "The index must not point at an existing key.";
        index2 ^= 0xFFFFFFFF;
        if (key == 0L) {
            assert (index2 == this.mask + 1);
            this.values[index2] = value2;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index2] == 0L);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index2, key, value2);
            } else {
                this.keys[index2] = key;
                this.values[index2] = value2;
            }
            ++this.assigned;
        }
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0L);
        Arrays.fill(this.values, null);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (LongObjectCursor<VType> c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((LongObjectHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(LongObjectHashMap<?> other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (LongObjectCursor<?> c : other) {
            long key = c.key;
            if (this.containsKey(key) && Objects.equals(this.get(key), c.value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            long[] prevKeys = this.keys;
            Object[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public Iterator<LongObjectCursor<VType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends LongObjectProcedure<? super VType>> T forEach(T procedure) {
        long[] keys = this.keys;
        Object[] values2 = this.values;
        if (this.hasEmptyKey) {
            procedure.apply(0L, (Object)values2[this.mask + 1]);
        }
        int max2 = this.mask;
        for (int slot = 0; slot <= max2; ++slot) {
            if (keys[slot] == 0L) continue;
            procedure.apply(keys[slot], (Object)values2[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends LongObjectPredicate<? super VType>> T forEach(T predicate) {
        long[] keys = this.keys;
        Object[] values2 = this.values;
        if (this.hasEmptyKey && !predicate.apply(0L, (Object)values2[this.mask + 1])) {
            return predicate;
        }
        int max2 = this.mask;
        for (int slot = 0; slot <= max2 && (keys[slot] == 0L || predicate.apply(keys[slot], (Object)values2[slot])); ++slot) {
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public ObjectCollection<VType> values() {
        return new ValuesContainer();
    }

    public LongObjectHashMap<VType> clone() {
        try {
            LongObjectHashMap cloned = (LongObjectHashMap)super.clone();
            cloned.keys = (long[])this.keys.clone();
            cloned.values = (Object[])this.values.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (LongObjectCursor<VType> cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters2) {
        return LongBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters2);
    }

    public static <VType> LongObjectHashMap<VType> from(long[] keys, VType[] values2) {
        if (keys.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        LongObjectHashMap<VType> map2 = new LongObjectHashMap<VType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map2.put(keys[i], values2[i]);
        }
        return map2;
    }

    protected int hashKey(long key) {
        assert (key != 0L);
        return BitMixer.mix(key, this.keyMixer);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(long[] fromKeys, VType[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        long[] keys = this.keys;
        Object[] values2 = this.values;
        int mask = this.mask;
        int from2 = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from2];
        values2[values2.length - 1] = fromValues[from2];
        while (--from2 >= 0) {
            long existing = fromKeys[from2];
            if (existing == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values2[slot] = fromValues[from2];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        long[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new long[arraySize + emptyElementSlot];
            this.values = new Object[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, long pendingKey, VType pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0L && pendingKey != 0L);
        long[] prevKeys = this.keys;
        Object[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        long existing;
        long[] keys = this.keys;
        Object[] values2 = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0L) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values2[gapSlot] = values2[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0L;
        values2[gapSlot] = null;
        --this.assigned;
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = LongObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCursor();
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    if (LongObjectHashMap.this.keys[this.slot] != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.value = LongObjectHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && LongObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = LongObjectHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractObjectCollection<VType> {
        private final LongObjectHashMap<VType> owner;

        private ValuesContainer() {
            this.owner = LongObjectHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(VType value2) {
            for (LongObjectCursor c : this.owner) {
                if (!Objects.equals(c.value, value2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectProcedure<? super VType>> T forEach(T procedure) {
            for (LongObjectCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super VType>> T forEach(T predicate) {
            for (LongObjectCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(final VType e) {
            return this.owner.removeAll(new LongObjectPredicate<VType>(){

                @Override
                public boolean apply(long key, VType value2) {
                    return Objects.equals(value2, e);
                }
            });
        }

        @Override
        public int removeAll(final ObjectPredicate<? super VType> predicate) {
            return this.owner.removeAll(new LongObjectPredicate<VType>(){

                @Override
                public boolean apply(long key, VType value2) {
                    return predicate.apply(value2);
                }
            });
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = LongObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongCursor();
        }

        @Override
        protected LongCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    long existing = LongObjectHashMap.this.keys[this.slot];
                    if (existing != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && LongObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0L;
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final LongObjectHashMap<VType> owner;

        public KeysContainer() {
            this.owner = LongObjectHashMap.this;
        }

        @Override
        public boolean contains(long e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends LongProcedure> T forEach(final T procedure) {
            this.owner.forEach(new LongObjectProcedure<VType>(){

                @Override
                public void apply(long key, VType value2) {
                    procedure.apply(key);
                }
            });
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(final T predicate) {
            this.owner.forEach(new LongObjectPredicate<VType>(){

                @Override
                public boolean apply(long key, VType value2) {
                    return predicate.apply(key);
                }
            });
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(long e) {
            boolean hasKey = this.owner.containsKey(e);
            if (hasKey) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<LongObjectCursor<VType>> {
        private final LongObjectCursor<VType> cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = LongObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongObjectCursor();
        }

        @Override
        protected LongObjectCursor<VType> fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    long existing = LongObjectHashMap.this.keys[this.slot];
                    if (existing != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.key = existing;
                        this.cursor.value = LongObjectHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && LongObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0L;
                this.cursor.value = LongObjectHashMap.this.values[this.max];
                return this.cursor;
            }
            return (LongObjectCursor)this.done();
        }
    }
}

