/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.LongIntHashMap;

public class LongIntScatterMap
extends LongIntHashMap {
    public LongIntScatterMap() {
        this(4);
    }

    public LongIntScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public LongIntScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(long key) {
        return BitMixer.mixPhi(key);
    }

    public static LongIntScatterMap from(long[] keys, int[] values2) {
        if (keys.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        LongIntScatterMap map2 = new LongIntScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map2.put(keys[i], values2[i]);
        }
        return map2;
    }
}

