/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.LongBufferVisualizer;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.LongSet;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class LongHashSet
extends AbstractLongCollection
implements LongLookupContainer,
LongSet,
Preallocable,
Cloneable {
    public long[] keys;
    protected int assigned;
    protected int mask;
    protected int keyMixer;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public LongHashSet() {
        this(4, 0.75);
    }

    public LongHashSet(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public LongHashSet(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public LongHashSet(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public LongHashSet(LongContainer container2) {
        this(container2.size());
        this.addAll(container2);
    }

    @Override
    public boolean add(long key) {
        long existing;
        if (key == 0L) {
            assert (this.keys[this.mask + 1] == 0L);
            boolean added = !this.hasEmptyKey;
            this.hasEmptyKey = true;
            return added;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key);
        } else {
            keys[slot] = key;
        }
        ++this.assigned;
        return true;
    }

    public final int addAll(long ... elements) {
        this.ensureCapacity(elements.length);
        int count2 = 0;
        for (long e : elements) {
            if (!this.add(e)) continue;
            ++count2;
        }
        return count2;
    }

    public int addAll(LongContainer container2) {
        this.ensureCapacity(container2.size());
        return this.addAll((Iterable<? extends LongCursor>)container2);
    }

    public int addAll(Iterable<? extends LongCursor> iterable) {
        int count2 = 0;
        for (LongCursor longCursor : iterable) {
            if (!this.add(longCursor.value)) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public long[] toArray() {
        long[] cloned = new long[this.size()];
        int j = 0;
        if (this.hasEmptyKey) {
            cloned[j++] = 0L;
        }
        long[] keys = this.keys;
        int max2 = this.mask;
        for (int slot = 0; slot <= max2; ++slot) {
            long existing = keys[slot];
            if (existing == 0L) continue;
            cloned[j++] = existing;
        }
        return cloned;
    }

    public boolean remove(long key) {
        long existing;
        if (key == 0L) {
            boolean hadEmptyKey = this.hasEmptyKey;
            this.hasEmptyKey = false;
            return hadEmptyKey;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int removeAll(long key) {
        return this.remove(key) ? 1 : 0;
    }

    @Override
    public int removeAll(LongPredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply(0L)) {
            this.hasEmptyKey = false;
        }
        long[] keys = this.keys;
        int slot = 0;
        int max2 = this.mask;
        while (slot <= max2) {
            long existing = keys[slot];
            if (existing != 0L && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public boolean contains(long key) {
        long existing;
        if (key == 0L) {
            return this.hasEmptyKey;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0L);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.ensureCapacity(4);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            long[] prevKeys = this.keys;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys);
            }
        }
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        long[] keys = this.keys;
        for (int slot = this.mask; slot >= 0; --slot) {
            long existing = keys[slot];
            if (existing == 0L) continue;
            h += BitMixer.mix(existing);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.sameKeys((LongSet)this.getClass().cast(obj));
    }

    private boolean sameKeys(LongSet other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (LongCursor c : other) {
            if (this.contains(c.value)) continue;
            return false;
        }
        return true;
    }

    public LongHashSet clone() {
        try {
            LongHashSet cloned = (LongHashSet)super.clone();
            cloned.keys = (long[])this.keys.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<LongCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends LongProcedure> T forEach(T procedure) {
        if (this.hasEmptyKey) {
            procedure.apply(0L);
        }
        long[] keys = this.keys;
        int max2 = this.mask;
        for (int slot = 0; slot <= max2; ++slot) {
            long existing = keys[slot];
            if (existing == 0L) continue;
            procedure.apply(existing);
        }
        return procedure;
    }

    @Override
    public <T extends LongPredicate> T forEach(T predicate) {
        long existing;
        if (this.hasEmptyKey && !predicate.apply(0L)) {
            return predicate;
        }
        long[] keys = this.keys;
        int max2 = this.mask;
        for (int slot = 0; slot <= max2 && ((existing = keys[slot]) == 0L || predicate.apply(existing)); ++slot) {
        }
        return predicate;
    }

    public static LongHashSet from(long ... elements) {
        LongHashSet set2 = new LongHashSet(elements.length);
        set2.addAll(elements);
        return set2;
    }

    protected int hashKey(long key) {
        assert (key != 0L);
        return BitMixer.mix(key, this.keyMixer);
    }

    public int indexOf(long key) {
        long existing;
        int mask = this.mask;
        if (key == 0L) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    public boolean indexExists(int index2) {
        assert (index2 < 0 || index2 >= 0 && index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        return index2 >= 0;
    }

    public long indexGet(int index2) {
        assert (index2 >= 0) : "The index must point at an existing key.";
        assert (index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        return this.keys[index2];
    }

    public long indexReplace(int index2, long equivalentKey) {
        assert (index2 >= 0) : "The index must point at an existing key.";
        assert (index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        assert (equivalentKey == this.keys[index2]);
        long previousValue = this.keys[index2];
        this.keys[index2] = equivalentKey;
        return previousValue;
    }

    public void indexInsert(int index2, long key) {
        assert (index2 < 0) : "The index must not point at an existing key.";
        index2 ^= 0xFFFFFFFF;
        if (key == 0L) {
            assert (index2 == this.mask + 1);
            assert (this.keys[index2] == 0L);
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index2] == 0L);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index2, key);
            } else {
                this.keys[index2] = key;
            }
            ++this.assigned;
        }
    }

    @Override
    public String visualizeKeyDistribution(int characters2) {
        return LongBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters2);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(long[] fromKeys) {
        assert (HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        long[] keys = this.keys;
        int mask = this.mask;
        int i = fromKeys.length - 1;
        while (--i >= 0) {
            long existing = fromKeys[i];
            if (existing == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        long[] prevKeys = this.keys;
        try {
            int emptyElementSlot = 1;
            this.keys = new long[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.keys == null ? 0 : this.size(), arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, long pendingKey) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0L && pendingKey != 0L);
        long[] prevKeys = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        this.rehash(prevKeys);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        long existing;
        long[] keys = this.keys;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0L) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0L;
        --this.assigned;
    }

    protected final class EntryIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = LongHashSet.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongCursor();
        }

        @Override
        protected LongCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    long existing = LongHashSet.this.keys[this.slot];
                    if (existing != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && LongHashSet.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0L;
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }
}

