/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.LongFloatHashMap;

public class LongFloatScatterMap
extends LongFloatHashMap {
    public LongFloatScatterMap() {
        this(4);
    }

    public LongFloatScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public LongFloatScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(long key) {
        return BitMixer.mixPhi(key);
    }

    public static LongFloatScatterMap from(long[] keys, float[] values2) {
        if (keys.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        LongFloatScatterMap map2 = new LongFloatScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map2.put(keys[i], values2[i]);
        }
        return map2;
    }
}

