/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractFloatCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.FloatCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.LongBufferVisualizer;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongFloatAssociativeContainer;
import com.carrotsearch.hppc.LongFloatMap;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.LongFloatCursor;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.predicates.LongFloatPredicate;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.FloatProcedure;
import com.carrotsearch.hppc.procedures.LongFloatProcedure;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class LongFloatHashMap
implements LongFloatMap,
Preallocable,
Cloneable {
    public long[] keys;
    public float[] values;
    protected int keyMixer;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public LongFloatHashMap() {
        this(4);
    }

    public LongFloatHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public LongFloatHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public LongFloatHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public LongFloatHashMap(LongFloatAssociativeContainer container2) {
        this(container2.size());
        this.putAll(container2);
    }

    @Override
    public float put(long key, float value2) {
        long existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == 0L) {
            this.hasEmptyKey = true;
            float previousValue = this.values[mask + 1];
            this.values[mask + 1] = value2;
            return previousValue;
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                float previousValue = this.values[slot];
                this.values[slot] = value2;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value2);
        } else {
            keys[slot] = key;
            this.values[slot] = value2;
        }
        ++this.assigned;
        return 0.0f;
    }

    @Override
    public int putAll(LongFloatAssociativeContainer container2) {
        int count2 = this.size();
        for (LongFloatCursor c : container2) {
            this.put(c.key, c.value);
        }
        return this.size() - count2;
    }

    @Override
    public int putAll(Iterable<? extends LongFloatCursor> iterable) {
        int count2 = this.size();
        for (LongFloatCursor longFloatCursor : iterable) {
            this.put(longFloatCursor.key, longFloatCursor.value);
        }
        return this.size() - count2;
    }

    public boolean putIfAbsent(long key, float value2) {
        if (!this.containsKey(key)) {
            this.put(key, value2);
            return true;
        }
        return false;
    }

    @Override
    public float putOrAdd(long key, float putValue, float incrementValue) {
        assert (this.assigned < this.mask + 1);
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue += incrementValue;
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public float addTo(long key, float incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    @Override
    public float remove(long key) {
        long existing;
        int mask = this.mask;
        if (key == 0L) {
            this.hasEmptyKey = false;
            float previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0.0f;
            return previousValue;
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                float previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return 0.0f;
    }

    @Override
    public int removeAll(LongContainer other) {
        int before = this.size();
        if (other.size() >= this.size() && other instanceof LongLookupContainer) {
            if (this.hasEmptyKey && other.contains(0L)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0.0f;
            }
            long[] keys = this.keys;
            int slot = 0;
            int max2 = this.mask;
            while (slot <= max2) {
                long existing = keys[slot];
                if (existing != 0L && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (LongCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(LongFloatPredicate predicate) {
        int before = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply(0L, this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = 0.0f;
        }
        long[] keys = this.keys;
        float[] values2 = this.values;
        int slot = 0;
        while (slot <= mask) {
            long existing = keys[slot];
            if (existing != 0L && predicate.apply(existing, values2[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(LongPredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply(0L)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0.0f;
        }
        long[] keys = this.keys;
        int slot = 0;
        int max2 = this.mask;
        while (slot <= max2) {
            long existing = keys[slot];
            if (existing != 0L && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public float get(long key) {
        long existing;
        if (key == 0L) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : 0.0f;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0.0f;
    }

    @Override
    public float getOrDefault(long key, float defaultValue2) {
        long existing;
        if (key == 0L) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue2;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue2;
    }

    @Override
    public boolean containsKey(long key) {
        long existing;
        if (key == 0L) {
            return this.hasEmptyKey;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(long key) {
        long existing;
        int mask = this.mask;
        if (key == 0L) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index2) {
        assert (index2 < 0 || index2 >= 0 && index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        return index2 >= 0;
    }

    @Override
    public float indexGet(int index2) {
        assert (index2 >= 0) : "The index must point at an existing key.";
        assert (index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        return this.values[index2];
    }

    @Override
    public float indexReplace(int index2, float newValue) {
        assert (index2 >= 0) : "The index must point at an existing key.";
        assert (index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        float previousValue = this.values[index2];
        this.values[index2] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index2, long key, float value2) {
        assert (index2 < 0) : "The index must not point at an existing key.";
        index2 ^= 0xFFFFFFFF;
        if (key == 0L) {
            assert (index2 == this.mask + 1);
            this.values[index2] = value2;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index2] == 0L);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index2, key, value2);
            } else {
                this.keys[index2] = key;
                this.values[index2] = value2;
            }
            ++this.assigned;
        }
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0L);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (LongFloatCursor c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((LongFloatHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(LongFloatHashMap other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (LongFloatCursor c : other) {
            long key = c.key;
            if (this.containsKey(key) && Float.floatToIntBits(this.get(key)) == Float.floatToIntBits(c.value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            long[] prevKeys = this.keys;
            float[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public Iterator<LongFloatCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends LongFloatProcedure> T forEach(T procedure) {
        long[] keys = this.keys;
        float[] values2 = this.values;
        if (this.hasEmptyKey) {
            procedure.apply(0L, values2[this.mask + 1]);
        }
        int max2 = this.mask;
        for (int slot = 0; slot <= max2; ++slot) {
            if (keys[slot] == 0L) continue;
            procedure.apply(keys[slot], values2[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends LongFloatPredicate> T forEach(T predicate) {
        long[] keys = this.keys;
        float[] values2 = this.values;
        if (this.hasEmptyKey && !predicate.apply(0L, values2[this.mask + 1])) {
            return predicate;
        }
        int max2 = this.mask;
        for (int slot = 0; slot <= max2 && (keys[slot] == 0L || predicate.apply(keys[slot], values2[slot])); ++slot) {
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public FloatCollection values() {
        return new ValuesContainer();
    }

    public LongFloatHashMap clone() {
        try {
            LongFloatHashMap cloned = (LongFloatHashMap)super.clone();
            cloned.keys = (long[])this.keys.clone();
            cloned.values = (float[])this.values.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (LongFloatCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters2) {
        return LongBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters2);
    }

    public static LongFloatHashMap from(long[] keys, float[] values2) {
        if (keys.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        LongFloatHashMap map2 = new LongFloatHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map2.put(keys[i], values2[i]);
        }
        return map2;
    }

    protected int hashKey(long key) {
        assert (key != 0L);
        return BitMixer.mix(key, this.keyMixer);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(long[] fromKeys, float[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        long[] keys = this.keys;
        float[] values2 = this.values;
        int mask = this.mask;
        int from2 = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from2];
        values2[values2.length - 1] = fromValues[from2];
        while (--from2 >= 0) {
            long existing = fromKeys[from2];
            if (existing == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values2[slot] = fromValues[from2];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        long[] prevKeys = this.keys;
        float[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new long[arraySize + emptyElementSlot];
            this.values = new float[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, long pendingKey, float pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0L && pendingKey != 0L);
        long[] prevKeys = this.keys;
        float[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        long existing;
        long[] keys = this.keys;
        float[] values2 = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0L) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values2[gapSlot] = values2[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0L;
        values2[gapSlot] = 0.0f;
        --this.assigned;
    }

    private final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = LongFloatHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new FloatCursor();
        }

        @Override
        protected FloatCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    if (LongFloatHashMap.this.keys[this.slot] != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.value = LongFloatHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && LongFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = LongFloatHashMap.this.values[this.max];
                return this.cursor;
            }
            return (FloatCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractFloatCollection {
        private final LongFloatHashMap owner;

        private ValuesContainer() {
            this.owner = LongFloatHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(float value2) {
            for (LongFloatCursor c : this.owner) {
                if (Float.floatToIntBits(c.value) != Float.floatToIntBits(value2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T procedure) {
            for (LongFloatCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T predicate) {
            for (LongFloatCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<FloatCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(final float e) {
            return this.owner.removeAll(new LongFloatPredicate(){

                @Override
                public boolean apply(long key, float value2) {
                    return Float.floatToIntBits(value2) == Float.floatToIntBits(e);
                }
            });
        }

        @Override
        public int removeAll(final FloatPredicate predicate) {
            return this.owner.removeAll(new LongFloatPredicate(){

                @Override
                public boolean apply(long key, float value2) {
                    return predicate.apply(value2);
                }
            });
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = LongFloatHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongCursor();
        }

        @Override
        protected LongCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    long existing = LongFloatHashMap.this.keys[this.slot];
                    if (existing != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && LongFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0L;
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractLongCollection
    implements LongLookupContainer {
        private final LongFloatHashMap owner;

        public KeysContainer() {
            this.owner = LongFloatHashMap.this;
        }

        @Override
        public boolean contains(long e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends LongProcedure> T forEach(final T procedure) {
            this.owner.forEach(new LongFloatProcedure(){

                @Override
                public void apply(long key, float value2) {
                    procedure.apply(key);
                }
            });
            return procedure;
        }

        @Override
        public <T extends LongPredicate> T forEach(final T predicate) {
            this.owner.forEach(new LongFloatPredicate(){

                @Override
                public boolean apply(long key, float value2) {
                    return predicate.apply(key);
                }
            });
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(LongPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(long e) {
            boolean hasKey = this.owner.containsKey(e);
            if (hasKey) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<LongFloatCursor> {
        private final LongFloatCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = LongFloatHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongFloatCursor();
        }

        @Override
        protected LongFloatCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    long existing = LongFloatHashMap.this.keys[this.slot];
                    if (existing != 0L) {
                        this.cursor.index = this.slot;
                        this.cursor.key = existing;
                        this.cursor.value = LongFloatHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && LongFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0L;
                this.cursor.value = LongFloatHashMap.this.values[this.max];
                return this.cursor;
            }
            return (LongFloatCursor)this.done();
        }
    }
}

