/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongDeque;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.procedures.LongProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class LongArrayDeque
extends AbstractLongCollection
implements LongDeque,
Preallocable,
Cloneable {
    public long[] buffer = LongArrayList.EMPTY_ARRAY;
    public int head;
    public int tail;
    protected final ArraySizingStrategy resizer;

    public LongArrayDeque() {
        this(4);
    }

    public LongArrayDeque(int expectedElements) {
        this(expectedElements, new BoundedProportionalArraySizingStrategy());
    }

    public LongArrayDeque(int expectedElements, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureCapacity(expectedElements);
    }

    public LongArrayDeque(LongContainer container2) {
        this(container2.size());
        this.addLast(container2);
    }

    @Override
    public void addFirst(long e1) {
        int h = LongArrayDeque.oneLeft(this.head, this.buffer.length);
        if (h == this.tail) {
            this.ensureBufferSpace(1);
            h = LongArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        this.head = h;
        this.buffer[this.head] = e1;
    }

    public final void addFirst(long ... elements) {
        this.ensureBufferSpace(elements.length);
        for (long k : elements) {
            this.addFirst(k);
        }
    }

    public int addFirst(LongContainer container2) {
        int size2 = container2.size();
        this.ensureBufferSpace(size2);
        for (LongCursor cursor : container2) {
            this.addFirst(cursor.value);
        }
        return size2;
    }

    public int addFirst(Iterable<? extends LongCursor> iterable) {
        int size2 = 0;
        for (LongCursor longCursor : iterable) {
            this.addFirst(longCursor.value);
            ++size2;
        }
        return size2;
    }

    @Override
    public void addLast(long e1) {
        int t = LongArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == t) {
            this.ensureBufferSpace(1);
            t = LongArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = e1;
        this.tail = t;
    }

    public final void addLast(long ... elements) {
        this.ensureBufferSpace(1);
        for (long k : elements) {
            this.addLast(k);
        }
    }

    public int addLast(LongContainer container2) {
        int size2 = container2.size();
        this.ensureBufferSpace(size2);
        for (LongCursor cursor : container2) {
            this.addLast(cursor.value);
        }
        return size2;
    }

    public int addLast(Iterable<? extends LongCursor> iterable) {
        int size2 = 0;
        for (LongCursor longCursor : iterable) {
            this.addLast(longCursor.value);
            ++size2;
        }
        return size2;
    }

    @Override
    public long removeFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        long result2 = this.buffer[this.head];
        this.buffer[this.head] = 0L;
        this.head = LongArrayDeque.oneRight(this.head, this.buffer.length);
        return result2;
    }

    @Override
    public long removeLast() {
        assert (this.size() > 0) : "The deque is empty.";
        this.tail = LongArrayDeque.oneLeft(this.tail, this.buffer.length);
        long result2 = this.buffer[this.tail];
        this.buffer[this.tail] = 0L;
        return result2;
    }

    @Override
    public long getFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[this.head];
    }

    @Override
    public long getLast() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[LongArrayDeque.oneLeft(this.tail, this.buffer.length)];
    }

    @Override
    public int removeFirst(long e1) {
        int index2 = this.bufferIndexOf(e1);
        if (index2 >= 0) {
            this.removeAtBufferIndex(index2);
        }
        return index2;
    }

    public int bufferIndexOf(long e1) {
        int last2 = this.tail;
        int bufLen = this.buffer.length;
        int i = this.head;
        while (i != last2) {
            if (this.buffer[i] == e1) {
                return i;
            }
            i = LongArrayDeque.oneRight(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeLast(long e1) {
        int index2 = this.lastBufferIndexOf(e1);
        if (index2 >= 0) {
            this.removeAtBufferIndex(index2);
        }
        return index2;
    }

    public int lastBufferIndexOf(long e1) {
        int bufLen = this.buffer.length;
        int last2 = LongArrayDeque.oneLeft(this.head, bufLen);
        int i = LongArrayDeque.oneLeft(this.tail, bufLen);
        while (i != last2) {
            if (this.buffer[i] == e1) {
                return i;
            }
            i = LongArrayDeque.oneLeft(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeAll(long e1) {
        int to2;
        int removed = 0;
        int last2 = this.tail;
        int bufLen = this.buffer.length;
        int from2 = to2 = this.head;
        while (from2 != last2) {
            if (this.buffer[from2] == e1) {
                this.buffer[from2] = 0L;
                ++removed;
            } else {
                if (to2 != from2) {
                    this.buffer[to2] = this.buffer[from2];
                    this.buffer[from2] = 0L;
                }
                to2 = LongArrayDeque.oneRight(to2, bufLen);
            }
            from2 = LongArrayDeque.oneRight(from2, bufLen);
        }
        this.tail = to2;
        return removed;
    }

    public void removeAtBufferIndex(int index2) {
        int rightChunk;
        assert (this.head > this.tail ? index2 >= this.head || index2 < this.tail : index2 >= this.head && index2 < this.tail) : "Index out of range (head=" + this.head + ", tail=" + this.tail + ", index=" + index2 + ").";
        long[] buffer = this.buffer;
        int bufLen = buffer.length;
        int lastIndex = bufLen - 1;
        int head2 = this.head;
        int tail = this.tail;
        int leftChunk = Math.abs(index2 - head2) % bufLen;
        if (leftChunk < (rightChunk = Math.abs(tail - index2) % bufLen)) {
            if (index2 >= head2) {
                System.arraycopy(buffer, head2, buffer, head2 + 1, leftChunk);
            } else {
                System.arraycopy(buffer, 0, buffer, 1, index2);
                buffer[0] = buffer[lastIndex];
                System.arraycopy(buffer, head2, buffer, head2 + 1, lastIndex - head2);
            }
            buffer[head2] = 0L;
            this.head = LongArrayDeque.oneRight(head2, bufLen);
        } else {
            if (index2 < tail) {
                System.arraycopy(buffer, index2 + 1, buffer, index2, rightChunk);
            } else {
                System.arraycopy(buffer, index2 + 1, buffer, index2, lastIndex - index2);
                buffer[lastIndex] = buffer[0];
                System.arraycopy(buffer, 1, buffer, 0, tail);
            }
            buffer[tail] = 0L;
            this.tail = LongArrayDeque.oneLeft(tail, bufLen);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.tail - this.head + this.buffer.length;
    }

    @Override
    public void clear() {
        if (this.head < this.tail) {
            Arrays.fill(this.buffer, this.head, this.tail, 0L);
        } else {
            Arrays.fill(this.buffer, 0, this.tail, 0L);
            Arrays.fill(this.buffer, this.head, this.buffer.length, 0L);
        }
        this.tail = 0;
        this.head = 0;
    }

    @Override
    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = LongArrayList.EMPTY_ARRAY;
        this.ensureBufferSpace(0);
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        this.ensureBufferSpace(expectedElements - this.size());
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen = this.buffer.length;
        int elementsCount = this.size();
        if (elementsCount + expectedAdditions >= bufferLen) {
            boolean emptySlot = true;
            int newSize = this.resizer.grow(bufferLen, elementsCount + 1, expectedAdditions);
            assert (newSize >= elementsCount + expectedAdditions + 1) : "Resizer failed to return sensible new size: " + newSize + " <= " + (elementsCount + expectedAdditions);
            try {
                long[] newBuffer = new long[newSize];
                if (bufferLen > 0) {
                    this.toArray(newBuffer);
                    this.tail = elementsCount;
                    this.head = 0;
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate new buffers: %,d -> %,d", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    @Override
    public long[] toArray() {
        int size2 = this.size();
        return this.toArray(new long[size2]);
    }

    public long[] toArray(long[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        if (this.head < this.tail) {
            System.arraycopy(this.buffer, this.head, target, 0, this.size());
        } else if (this.head > this.tail) {
            int rightCount = this.buffer.length - this.head;
            System.arraycopy(this.buffer, this.head, target, 0, rightCount);
            System.arraycopy(this.buffer, 0, target, rightCount, this.tail);
        }
        return target;
    }

    public LongArrayDeque clone() {
        try {
            LongArrayDeque cloned = (LongArrayDeque)super.clone();
            cloned.buffer = (long[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected static int oneLeft(int index2, int modulus) {
        if (index2 >= 1) {
            return index2 - 1;
        }
        return modulus - 1;
    }

    protected static int oneRight(int index2, int modulus) {
        if (index2 + 1 == modulus) {
            return 0;
        }
        return index2 + 1;
    }

    @Override
    public Iterator<LongCursor> iterator() {
        return new ValueIterator();
    }

    @Override
    public Iterator<LongCursor> descendingIterator() {
        return new DescendingValueIterator();
    }

    @Override
    public <T extends LongProcedure> T forEach(T procedure) {
        this.forEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void forEach(LongProcedure procedure, int fromIndex, int toIndex) {
        long[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            procedure.apply(buffer[i]);
            i = LongArrayDeque.oneRight(i, buffer.length);
        }
    }

    @Override
    public <T extends LongPredicate> T forEach(T predicate) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        long[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex && predicate.apply(buffer[i])) {
            i = LongArrayDeque.oneRight(i, buffer.length);
        }
        return predicate;
    }

    @Override
    public <T extends LongProcedure> T descendingForEach(T procedure) {
        this.descendingForEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void descendingForEach(LongProcedure procedure, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        long[] buffer = this.buffer;
        int i = toIndex;
        do {
            i = LongArrayDeque.oneLeft(i, buffer.length);
            procedure.apply(buffer[i]);
        } while (i != fromIndex);
    }

    @Override
    public <T extends LongPredicate> T descendingForEach(T predicate) {
        this.descendingForEach(predicate, this.head, this.tail);
        return predicate;
    }

    private void descendingForEach(LongPredicate predicate, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        long[] buffer = this.buffer;
        int i = toIndex;
        while (predicate.apply(buffer[i = LongArrayDeque.oneLeft(i, buffer.length)]) && i != fromIndex) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(LongPredicate predicate) {
        int to2;
        long[] buffer = this.buffer;
        int last2 = this.tail;
        int bufLen = buffer.length;
        int removed = 0;
        int from2 = to2 = this.head;
        try {
            from2 = to2 = this.head;
            while (from2 != last2) {
                if (predicate.apply(buffer[from2])) {
                    buffer[from2] = 0L;
                    ++removed;
                } else {
                    if (to2 != from2) {
                        buffer[to2] = buffer[from2];
                        buffer[from2] = 0L;
                    }
                    to2 = LongArrayDeque.oneRight(to2, bufLen);
                }
                from2 = LongArrayDeque.oneRight(from2, bufLen);
            }
        }
        finally {
            while (from2 != last2) {
                if (to2 != from2) {
                    buffer[to2] = buffer[from2];
                    buffer[from2] = 0L;
                }
                to2 = LongArrayDeque.oneRight(to2, bufLen);
                from2 = LongArrayDeque.oneRight(from2, bufLen);
            }
            this.tail = to2;
        }
        return removed;
    }

    @Override
    public boolean contains(long e) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        long[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            if (buffer[i] == e) {
                return true;
            }
            i = LongArrayDeque.oneRight(i, buffer.length);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        int fromIndex = this.head;
        int toIndex = this.tail;
        long[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            h = 31 * h + BitMixer.mix(this.buffer[i]);
            i = LongArrayDeque.oneRight(i, buffer.length);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((LongArrayDeque)this.getClass().cast(obj));
    }

    protected boolean equalElements(LongArrayDeque other) {
        int max2 = this.size();
        if (other.size() != max2) {
            return false;
        }
        Iterator<LongCursor> i1 = this.iterator();
        Iterator<LongCursor> i2 = other.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i2.next().value == i1.next().value) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public static LongArrayDeque from(long ... elements) {
        LongArrayDeque coll = new LongArrayDeque(elements.length);
        coll.addLast(elements);
        return coll;
    }

    private final class DescendingValueIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private int remaining;

        public DescendingValueIterator() {
            this.cursor.index = LongArrayDeque.this.tail;
            this.remaining = LongArrayDeque.this.size();
        }

        @Override
        protected LongCursor fetch() {
            if (this.remaining == 0) {
                return (LongCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = LongArrayDeque.oneLeft(this.cursor.index, LongArrayDeque.this.buffer.length);
            this.cursor.value = LongArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }

    private final class ValueIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private int remaining;

        public ValueIterator() {
            this.cursor.index = LongArrayDeque.oneLeft(LongArrayDeque.this.head, LongArrayDeque.this.buffer.length);
            this.remaining = LongArrayDeque.this.size();
        }

        @Override
        protected LongCursor fetch() {
            if (this.remaining == 0) {
                return (LongCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = LongArrayDeque.oneRight(this.cursor.index, LongArrayDeque.this.buffer.length);
            this.cursor.value = LongArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }
}

