/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.IntShortHashMap;

public class IntShortScatterMap
extends IntShortHashMap {
    public IntShortScatterMap() {
        this(4);
    }

    public IntShortScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public IntShortScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(int key) {
        return BitMixer.mixPhi(key);
    }

    public static IntShortScatterMap from(int[] keys, short[] values2) {
        if (keys.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        IntShortScatterMap map2 = new IntShortScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map2.put(keys[i], values2[i]);
        }
        return map2;
    }
}

