/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.IntBufferVisualizer;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.IntShortAssociativeContainer;
import com.carrotsearch.hppc.IntShortMap;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.ShortCollection;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntShortCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.predicates.IntShortPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.carrotsearch.hppc.procedures.IntShortProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class IntShortHashMap
implements IntShortMap,
Preallocable,
Cloneable {
    public int[] keys;
    public short[] values;
    protected int keyMixer;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected HashOrderMixingStrategy orderMixer;

    public IntShortHashMap() {
        this(4);
    }

    public IntShortHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public IntShortHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.defaultStrategy());
    }

    public IntShortHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public IntShortHashMap(IntShortAssociativeContainer container2) {
        this(container2.size());
        this.putAll(container2);
    }

    @Override
    public short put(int key, short value2) {
        int existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == 0) {
            this.hasEmptyKey = true;
            short previousValue = this.values[mask + 1];
            this.values[mask + 1] = value2;
            return previousValue;
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                short previousValue = this.values[slot];
                this.values[slot] = value2;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value2);
        } else {
            keys[slot] = key;
            this.values[slot] = value2;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(IntShortAssociativeContainer container2) {
        int count2 = this.size();
        for (IntShortCursor c : container2) {
            this.put(c.key, c.value);
        }
        return this.size() - count2;
    }

    @Override
    public int putAll(Iterable<? extends IntShortCursor> iterable) {
        int count2 = this.size();
        for (IntShortCursor intShortCursor : iterable) {
            this.put(intShortCursor.key, intShortCursor.value);
        }
        return this.size() - count2;
    }

    public boolean putIfAbsent(int key, short value2) {
        if (!this.containsKey(key)) {
            this.put(key, value2);
            return true;
        }
        return false;
    }

    @Override
    public short putOrAdd(int key, short putValue, short incrementValue) {
        assert (this.assigned < this.mask + 1);
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue = (short)(putValue + incrementValue);
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public short addTo(int key, short incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    @Override
    public short remove(int key) {
        int existing;
        int mask = this.mask;
        if (key == 0) {
            this.hasEmptyKey = false;
            short previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0;
            return previousValue;
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                short previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public int removeAll(IntContainer other) {
        int before = this.size();
        if (other.size() >= this.size() && other instanceof IntLookupContainer) {
            if (this.hasEmptyKey && other.contains(0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0;
            }
            int[] keys = this.keys;
            int slot = 0;
            int max2 = this.mask;
            while (slot <= max2) {
                int existing = keys[slot];
                if (existing != 0 && other.contains(existing)) {
                    this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
        } else {
            for (IntCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(IntShortPredicate predicate) {
        int before = this.size();
        int mask = this.mask;
        if (this.hasEmptyKey && predicate.apply(0, this.values[mask + 1])) {
            this.hasEmptyKey = false;
            this.values[mask + 1] = 0;
        }
        int[] keys = this.keys;
        short[] values2 = this.values;
        int slot = 0;
        while (slot <= mask) {
            int existing = keys[slot];
            if (existing != 0 && predicate.apply(existing, values2[slot])) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        int before = this.size();
        if (this.hasEmptyKey && predicate.apply(0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0;
        }
        int[] keys = this.keys;
        int slot = 0;
        int max2 = this.mask;
        while (slot <= max2) {
            int existing = keys[slot];
            if (existing != 0 && predicate.apply(existing)) {
                this.shiftConflictingKeys(slot);
                continue;
            }
            ++slot;
        }
        return before - this.size();
    }

    @Override
    public short get(int key) {
        int existing;
        if (key == 0) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : (short)0;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0;
    }

    @Override
    public short getOrDefault(int key, short defaultValue2) {
        int existing;
        if (key == 0) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue2;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue2;
    }

    @Override
    public boolean containsKey(int key) {
        int existing;
        if (key == 0) {
            return this.hasEmptyKey;
        }
        int[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public int indexOf(int key) {
        int existing;
        int mask = this.mask;
        if (key == 0) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        int[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0) {
            if (existing == key) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    @Override
    public boolean indexExists(int index2) {
        assert (index2 < 0 || index2 >= 0 && index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        return index2 >= 0;
    }

    @Override
    public short indexGet(int index2) {
        assert (index2 >= 0) : "The index must point at an existing key.";
        assert (index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        return this.values[index2];
    }

    @Override
    public short indexReplace(int index2, short newValue) {
        assert (index2 >= 0) : "The index must point at an existing key.";
        assert (index2 <= this.mask || index2 == this.mask + 1 && this.hasEmptyKey);
        short previousValue = this.values[index2];
        this.values[index2] = newValue;
        return previousValue;
    }

    @Override
    public void indexInsert(int index2, int key, short value2) {
        assert (index2 < 0) : "The index must not point at an existing key.";
        index2 ^= 0xFFFFFFFF;
        if (key == 0) {
            assert (index2 == this.mask + 1);
            this.values[index2] = value2;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index2] == 0);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index2, key, value2);
            } else {
                this.keys[index2] = key;
                this.values[index2] = value2;
            }
            ++this.assigned;
        }
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0);
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (IntShortCursor c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((IntShortHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(IntShortHashMap other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (IntShortCursor c : other) {
            int key = c.key;
            if (this.containsKey(key) && this.get(key) == c.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            int[] prevKeys = this.keys;
            short[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    @Override
    public Iterator<IntShortCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public <T extends IntShortProcedure> T forEach(T procedure) {
        int[] keys = this.keys;
        short[] values2 = this.values;
        if (this.hasEmptyKey) {
            procedure.apply(0, values2[this.mask + 1]);
        }
        int max2 = this.mask;
        for (int slot = 0; slot <= max2; ++slot) {
            if (keys[slot] == 0) continue;
            procedure.apply(keys[slot], values2[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends IntShortPredicate> T forEach(T predicate) {
        int[] keys = this.keys;
        short[] values2 = this.values;
        if (this.hasEmptyKey && !predicate.apply(0, values2[this.mask + 1])) {
            return predicate;
        }
        int max2 = this.mask;
        for (int slot = 0; slot <= max2 && (keys[slot] == 0 || predicate.apply(keys[slot], values2[slot])); ++slot) {
        }
        return predicate;
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public ShortCollection values() {
        return new ValuesContainer();
    }

    public IntShortHashMap clone() {
        try {
            IntShortHashMap cloned = (IntShortHashMap)super.clone();
            cloned.keys = (int[])this.keys.clone();
            cloned.values = (short[])this.values.clone();
            cloned.hasEmptyKey = cloned.hasEmptyKey;
            cloned.orderMixer = this.orderMixer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (IntShortCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public String visualizeKeyDistribution(int characters2) {
        return IntBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, characters2);
    }

    public static IntShortHashMap from(int[] keys, short[] values2) {
        if (keys.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        IntShortHashMap map2 = new IntShortHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map2.put(keys[i], values2[i]);
        }
        return map2;
    }

    protected int hashKey(int key) {
        assert (key != 0);
        return BitMixer.mix(key, this.keyMixer);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(int[] fromKeys, short[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        int[] keys = this.keys;
        short[] values2 = this.values;
        int mask = this.mask;
        int from2 = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from2];
        values2[values2.length - 1] = fromValues[from2];
        while (--from2 >= 0) {
            int existing = fromKeys[from2];
            if (existing == 0) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values2[slot] = fromValues[from2];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        int newKeyMixer = this.orderMixer.newKeyMixer(arraySize);
        int[] prevKeys = this.keys;
        short[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new int[arraySize + emptyElementSlot];
            this.values = new short[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.keyMixer = newKeyMixer;
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, int pendingKey, short pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0 && pendingKey != 0);
        int[] prevKeys = this.keys;
        short[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        int existing;
        int[] keys = this.keys;
        short[] values2 = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values2[gapSlot] = values2[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0;
        values2[gapSlot] = 0;
        --this.assigned;
    }

    private final class ValuesIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = IntShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    if (IntShortHashMap.this.keys[this.slot] != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.value = IntShortHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && IntShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = IntShortHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractShortCollection {
        private final IntShortHashMap owner;

        private ValuesContainer() {
            this.owner = IntShortHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(short value2) {
            for (IntShortCursor c : this.owner) {
                if (c.value != value2) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            for (IntShortCursor c : this.owner) {
                procedure.apply(c.value);
            }
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            for (IntShortCursor c : this.owner) {
                if (predicate.apply(c.value)) continue;
                break;
            }
            return predicate;
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(final short e) {
            return this.owner.removeAll(new IntShortPredicate(){

                @Override
                public boolean apply(int key, short value2) {
                    return value2 == e;
                }
            });
        }

        @Override
        public int removeAll(final ShortPredicate predicate) {
            return this.owner.removeAll(new IntShortPredicate(){

                @Override
                public boolean apply(int key, short value2) {
                    return predicate.apply(value2);
                }
            });
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = IntShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntCursor();
        }

        @Override
        protected IntCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    int existing = IntShortHashMap.this.keys[this.slot];
                    if (existing != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.value = existing;
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && IntShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = 0;
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final IntShortHashMap owner;

        public KeysContainer() {
            this.owner = IntShortHashMap.this;
        }

        @Override
        public boolean contains(int e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends IntProcedure> T forEach(final T procedure) {
            this.owner.forEach(new IntShortProcedure(){

                @Override
                public void apply(int key, short value2) {
                    procedure.apply(key);
                }
            });
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(final T predicate) {
            this.owner.forEach(new IntShortPredicate(){

                @Override
                public boolean apply(int key, short value2) {
                    return predicate.apply(key);
                }
            });
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(int e) {
            boolean hasKey = this.owner.containsKey(e);
            if (hasKey) {
                this.owner.remove(e);
                return 1;
            }
            return 0;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<IntShortCursor> {
        private final IntShortCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = IntShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntShortCursor();
        }

        @Override
        protected IntShortCursor fetch() {
            if (this.slot < this.max) {
                ++this.slot;
                while (this.slot < this.max) {
                    int existing = IntShortHashMap.this.keys[this.slot];
                    if (existing != 0) {
                        this.cursor.index = this.slot;
                        this.cursor.key = existing;
                        this.cursor.value = IntShortHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    ++this.slot;
                }
            }
            if (this.slot == this.max && IntShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = 0;
                this.cursor.value = IntShortHashMap.this.values[this.max];
                return this.cursor;
            }
            return (IntShortCursor)this.done();
        }
    }
}

