/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.DoubleArrayList;
import com.carrotsearch.hppc.DoubleContainer;
import com.carrotsearch.hppc.cursors.DoubleCursor;

public class DoubleStack
extends DoubleArrayList {
    public DoubleStack() {
    }

    public DoubleStack(int expectedElements) {
        super(expectedElements);
    }

    public DoubleStack(int expectedElements, ArraySizingStrategy resizer) {
        super(expectedElements, resizer);
    }

    public DoubleStack(DoubleContainer container2) {
        super(container2);
    }

    public void push(double e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void push(double e1, double e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void push(double e1, double e2, double e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public void push(double e1, double e2, double e3, double e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public void push(double[] elements, int start, int len) {
        assert (start >= 0 && len >= 0);
        this.ensureBufferSpace(len);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, len);
        this.elementsCount += len;
    }

    public final void push(double ... elements) {
        this.push(elements, 0, elements.length);
    }

    public int pushAll(DoubleContainer container2) {
        return this.addAll(container2);
    }

    public int pushAll(Iterable<? extends DoubleCursor> iterable) {
        return this.addAll(iterable);
    }

    public void discard(int count2) {
        assert (this.elementsCount >= count2);
        this.elementsCount -= count2;
    }

    public void discard() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
    }

    public double pop() {
        assert (this.elementsCount > 0);
        double v = this.buffer[--this.elementsCount];
        return v;
    }

    public double peek() {
        assert (this.elementsCount > 0);
        return this.buffer[this.elementsCount - 1];
    }

    public static DoubleStack from(double ... elements) {
        DoubleStack stack = new DoubleStack(elements.length);
        stack.push(elements);
        return stack;
    }

    @Override
    public DoubleStack clone() {
        return (DoubleStack)super.clone();
    }
}

