/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.CharDoubleHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class CharDoubleScatterMap
extends CharDoubleHashMap {
    public CharDoubleScatterMap() {
        this(4);
    }

    public CharDoubleScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharDoubleScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(char key) {
        return BitMixer.mixPhi(key);
    }

    public static CharDoubleScatterMap from(char[] keys, double[] values2) {
        if (keys.length != values2.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharDoubleScatterMap map2 = new CharDoubleScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map2.put(keys[i], values2[i]);
        }
        return map2;
    }
}

