/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.ArraySizingStrategy;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.CharArrayList;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharDeque;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.procedures.CharProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class CharArrayDeque
extends AbstractCharCollection
implements CharDeque,
Preallocable,
Cloneable {
    public char[] buffer = CharArrayList.EMPTY_ARRAY;
    public int head;
    public int tail;
    protected final ArraySizingStrategy resizer;

    public CharArrayDeque() {
        this(4);
    }

    public CharArrayDeque(int expectedElements) {
        this(expectedElements, new BoundedProportionalArraySizingStrategy());
    }

    public CharArrayDeque(int expectedElements, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureCapacity(expectedElements);
    }

    public CharArrayDeque(CharContainer container2) {
        this(container2.size());
        this.addLast(container2);
    }

    @Override
    public void addFirst(char e1) {
        int h = CharArrayDeque.oneLeft(this.head, this.buffer.length);
        if (h == this.tail) {
            this.ensureBufferSpace(1);
            h = CharArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        this.head = h;
        this.buffer[this.head] = e1;
    }

    public final void addFirst(char ... elements) {
        this.ensureBufferSpace(elements.length);
        for (char k : elements) {
            this.addFirst(k);
        }
    }

    public int addFirst(CharContainer container2) {
        int size2 = container2.size();
        this.ensureBufferSpace(size2);
        for (CharCursor cursor : container2) {
            this.addFirst(cursor.value);
        }
        return size2;
    }

    public int addFirst(Iterable<? extends CharCursor> iterable) {
        int size2 = 0;
        for (CharCursor charCursor : iterable) {
            this.addFirst(charCursor.value);
            ++size2;
        }
        return size2;
    }

    @Override
    public void addLast(char e1) {
        int t = CharArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == t) {
            this.ensureBufferSpace(1);
            t = CharArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = e1;
        this.tail = t;
    }

    public final void addLast(char ... elements) {
        this.ensureBufferSpace(1);
        for (char k : elements) {
            this.addLast(k);
        }
    }

    public int addLast(CharContainer container2) {
        int size2 = container2.size();
        this.ensureBufferSpace(size2);
        for (CharCursor cursor : container2) {
            this.addLast(cursor.value);
        }
        return size2;
    }

    public int addLast(Iterable<? extends CharCursor> iterable) {
        int size2 = 0;
        for (CharCursor charCursor : iterable) {
            this.addLast(charCursor.value);
            ++size2;
        }
        return size2;
    }

    @Override
    public char removeFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        char result2 = this.buffer[this.head];
        this.buffer[this.head] = '\u0000';
        this.head = CharArrayDeque.oneRight(this.head, this.buffer.length);
        return result2;
    }

    @Override
    public char removeLast() {
        assert (this.size() > 0) : "The deque is empty.";
        this.tail = CharArrayDeque.oneLeft(this.tail, this.buffer.length);
        char result2 = this.buffer[this.tail];
        this.buffer[this.tail] = '\u0000';
        return result2;
    }

    @Override
    public char getFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[this.head];
    }

    @Override
    public char getLast() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[CharArrayDeque.oneLeft(this.tail, this.buffer.length)];
    }

    @Override
    public int removeFirst(char e1) {
        int index2 = this.bufferIndexOf(e1);
        if (index2 >= 0) {
            this.removeAtBufferIndex(index2);
        }
        return index2;
    }

    public int bufferIndexOf(char e1) {
        int last2 = this.tail;
        int bufLen = this.buffer.length;
        int i = this.head;
        while (i != last2) {
            if (this.buffer[i] == e1) {
                return i;
            }
            i = CharArrayDeque.oneRight(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeLast(char e1) {
        int index2 = this.lastBufferIndexOf(e1);
        if (index2 >= 0) {
            this.removeAtBufferIndex(index2);
        }
        return index2;
    }

    public int lastBufferIndexOf(char e1) {
        int bufLen = this.buffer.length;
        int last2 = CharArrayDeque.oneLeft(this.head, bufLen);
        int i = CharArrayDeque.oneLeft(this.tail, bufLen);
        while (i != last2) {
            if (this.buffer[i] == e1) {
                return i;
            }
            i = CharArrayDeque.oneLeft(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeAll(char e1) {
        int to2;
        int removed = 0;
        int last2 = this.tail;
        int bufLen = this.buffer.length;
        int from2 = to2 = this.head;
        while (from2 != last2) {
            if (this.buffer[from2] == e1) {
                this.buffer[from2] = '\u0000';
                ++removed;
            } else {
                if (to2 != from2) {
                    this.buffer[to2] = this.buffer[from2];
                    this.buffer[from2] = '\u0000';
                }
                to2 = CharArrayDeque.oneRight(to2, bufLen);
            }
            from2 = CharArrayDeque.oneRight(from2, bufLen);
        }
        this.tail = to2;
        return removed;
    }

    public void removeAtBufferIndex(int index2) {
        int rightChunk;
        assert (this.head > this.tail ? index2 >= this.head || index2 < this.tail : index2 >= this.head && index2 < this.tail) : "Index out of range (head=" + this.head + ", tail=" + this.tail + ", index=" + index2 + ").";
        char[] buffer = this.buffer;
        int bufLen = buffer.length;
        int lastIndex = bufLen - 1;
        int head2 = this.head;
        int tail = this.tail;
        int leftChunk = Math.abs(index2 - head2) % bufLen;
        if (leftChunk < (rightChunk = Math.abs(tail - index2) % bufLen)) {
            if (index2 >= head2) {
                System.arraycopy(buffer, head2, buffer, head2 + 1, leftChunk);
            } else {
                System.arraycopy(buffer, 0, buffer, 1, index2);
                buffer[0] = buffer[lastIndex];
                System.arraycopy(buffer, head2, buffer, head2 + 1, lastIndex - head2);
            }
            buffer[head2] = '\u0000';
            this.head = CharArrayDeque.oneRight(head2, bufLen);
        } else {
            if (index2 < tail) {
                System.arraycopy(buffer, index2 + 1, buffer, index2, rightChunk);
            } else {
                System.arraycopy(buffer, index2 + 1, buffer, index2, lastIndex - index2);
                buffer[lastIndex] = buffer[0];
                System.arraycopy(buffer, 1, buffer, 0, tail);
            }
            buffer[tail] = '\u0000';
            this.tail = CharArrayDeque.oneLeft(tail, bufLen);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.tail - this.head + this.buffer.length;
    }

    @Override
    public void clear() {
        if (this.head < this.tail) {
            Arrays.fill(this.buffer, this.head, this.tail, '\u0000');
        } else {
            Arrays.fill(this.buffer, 0, this.tail, '\u0000');
            Arrays.fill(this.buffer, this.head, this.buffer.length, '\u0000');
        }
        this.tail = 0;
        this.head = 0;
    }

    @Override
    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = CharArrayList.EMPTY_ARRAY;
        this.ensureBufferSpace(0);
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        this.ensureBufferSpace(expectedElements - this.size());
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen = this.buffer.length;
        int elementsCount = this.size();
        if (elementsCount + expectedAdditions >= bufferLen) {
            boolean emptySlot = true;
            int newSize = this.resizer.grow(bufferLen, elementsCount + 1, expectedAdditions);
            assert (newSize >= elementsCount + expectedAdditions + 1) : "Resizer failed to return sensible new size: " + newSize + " <= " + (elementsCount + expectedAdditions);
            try {
                char[] newBuffer = new char[newSize];
                if (bufferLen > 0) {
                    this.toArray(newBuffer);
                    this.tail = elementsCount;
                    this.head = 0;
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate new buffers: %,d -> %,d", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    @Override
    public char[] toArray() {
        int size2 = this.size();
        return this.toArray(new char[size2]);
    }

    public char[] toArray(char[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        if (this.head < this.tail) {
            System.arraycopy(this.buffer, this.head, target, 0, this.size());
        } else if (this.head > this.tail) {
            int rightCount = this.buffer.length - this.head;
            System.arraycopy(this.buffer, this.head, target, 0, rightCount);
            System.arraycopy(this.buffer, 0, target, rightCount, this.tail);
        }
        return target;
    }

    public CharArrayDeque clone() {
        try {
            CharArrayDeque cloned = (CharArrayDeque)super.clone();
            cloned.buffer = (char[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected static int oneLeft(int index2, int modulus) {
        if (index2 >= 1) {
            return index2 - 1;
        }
        return modulus - 1;
    }

    protected static int oneRight(int index2, int modulus) {
        if (index2 + 1 == modulus) {
            return 0;
        }
        return index2 + 1;
    }

    @Override
    public Iterator<CharCursor> iterator() {
        return new ValueIterator();
    }

    @Override
    public Iterator<CharCursor> descendingIterator() {
        return new DescendingValueIterator();
    }

    @Override
    public <T extends CharProcedure> T forEach(T procedure) {
        this.forEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void forEach(CharProcedure procedure, int fromIndex, int toIndex) {
        char[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            procedure.apply(buffer[i]);
            i = CharArrayDeque.oneRight(i, buffer.length);
        }
    }

    @Override
    public <T extends CharPredicate> T forEach(T predicate) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        char[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex && predicate.apply(buffer[i])) {
            i = CharArrayDeque.oneRight(i, buffer.length);
        }
        return predicate;
    }

    @Override
    public <T extends CharProcedure> T descendingForEach(T procedure) {
        this.descendingForEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void descendingForEach(CharProcedure procedure, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        char[] buffer = this.buffer;
        int i = toIndex;
        do {
            i = CharArrayDeque.oneLeft(i, buffer.length);
            procedure.apply(buffer[i]);
        } while (i != fromIndex);
    }

    @Override
    public <T extends CharPredicate> T descendingForEach(T predicate) {
        this.descendingForEach(predicate, this.head, this.tail);
        return predicate;
    }

    private void descendingForEach(CharPredicate predicate, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        char[] buffer = this.buffer;
        int i = toIndex;
        while (predicate.apply(buffer[i = CharArrayDeque.oneLeft(i, buffer.length)]) && i != fromIndex) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(CharPredicate predicate) {
        int to2;
        char[] buffer = this.buffer;
        int last2 = this.tail;
        int bufLen = buffer.length;
        int removed = 0;
        int from2 = to2 = this.head;
        try {
            from2 = to2 = this.head;
            while (from2 != last2) {
                if (predicate.apply(buffer[from2])) {
                    buffer[from2] = '\u0000';
                    ++removed;
                } else {
                    if (to2 != from2) {
                        buffer[to2] = buffer[from2];
                        buffer[from2] = '\u0000';
                    }
                    to2 = CharArrayDeque.oneRight(to2, bufLen);
                }
                from2 = CharArrayDeque.oneRight(from2, bufLen);
            }
        }
        finally {
            while (from2 != last2) {
                if (to2 != from2) {
                    buffer[to2] = buffer[from2];
                    buffer[from2] = '\u0000';
                }
                to2 = CharArrayDeque.oneRight(to2, bufLen);
                from2 = CharArrayDeque.oneRight(from2, bufLen);
            }
            this.tail = to2;
        }
        return removed;
    }

    @Override
    public boolean contains(char e) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        char[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            if (buffer[i] == e) {
                return true;
            }
            i = CharArrayDeque.oneRight(i, buffer.length);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        int fromIndex = this.head;
        int toIndex = this.tail;
        char[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            h = 31 * h + BitMixer.mix(this.buffer[i]);
            i = CharArrayDeque.oneRight(i, buffer.length);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((CharArrayDeque)this.getClass().cast(obj));
    }

    protected boolean equalElements(CharArrayDeque other) {
        int max2 = this.size();
        if (other.size() != max2) {
            return false;
        }
        Iterator<CharCursor> i1 = this.iterator();
        Iterator<CharCursor> i2 = other.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i2.next().value == i1.next().value) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public static CharArrayDeque from(char ... elements) {
        CharArrayDeque coll = new CharArrayDeque(elements.length);
        coll.addLast(elements);
        return coll;
    }

    private final class DescendingValueIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private int remaining;

        public DescendingValueIterator() {
            this.cursor.index = CharArrayDeque.this.tail;
            this.remaining = CharArrayDeque.this.size();
        }

        @Override
        protected CharCursor fetch() {
            if (this.remaining == 0) {
                return (CharCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = CharArrayDeque.oneLeft(this.cursor.index, CharArrayDeque.this.buffer.length);
            this.cursor.value = CharArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }

    private final class ValueIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private int remaining;

        public ValueIterator() {
            this.cursor.index = CharArrayDeque.oneLeft(CharArrayDeque.this.head, CharArrayDeque.this.buffer.length);
            this.remaining = CharArrayDeque.this.size();
        }

        @Override
        protected CharCursor fetch() {
            if (this.remaining == 0) {
                return (CharCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = CharArrayDeque.oneRight(this.cursor.index, CharArrayDeque.this.buffer.length);
            this.cursor.value = CharArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }
}

