/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import java.lang.reflect.Array;
import java.util.Arrays;

abstract class AbstractObjectCollection<KType>
implements ObjectCollection<KType> {
    AbstractObjectCollection() {
    }

    @Override
    public int removeAll(final ObjectLookupContainer<? super KType> c) {
        return this.removeAll(new ObjectPredicate<KType>(){

            @Override
            public boolean apply(KType k) {
                return c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final ObjectLookupContainer<? super KType> c) {
        return this.removeAll(new ObjectPredicate<KType>(){

            @Override
            public boolean apply(KType k) {
                return !c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final ObjectPredicate<? super KType> predicate) {
        return this.removeAll(new ObjectPredicate<KType>(){

            @Override
            public boolean apply(KType value2) {
                return !predicate.apply(value2);
            }
        });
    }

    @Override
    public Object[] toArray() {
        Object[] array2 = new Object[this.size()];
        int i = 0;
        for (ObjectCursor c : this) {
            array2[i++] = c.value;
        }
        return array2;
    }

    @Override
    public <T> T[] toArray(Class<T> componentClass) {
        int size2 = this.size();
        Object[] array2 = (Object[])Array.newInstance(componentClass, size2);
        int i = 0;
        for (ObjectCursor c : this) {
            array2[i++] = c.value;
        }
        return array2;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    protected boolean equals(Object v1, Object v2) {
        return v1 == v2 || v1 != null && v1.equals(v2);
    }
}

