/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.LongCollection;
import com.carrotsearch.hppc.LongLookupContainer;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.predicates.LongPredicate;
import java.util.Arrays;

abstract class AbstractLongCollection
implements LongCollection {
    AbstractLongCollection() {
    }

    @Override
    public int removeAll(final LongLookupContainer c) {
        return this.removeAll(new LongPredicate(){

            @Override
            public boolean apply(long k) {
                return c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final LongLookupContainer c) {
        return this.removeAll(new LongPredicate(){

            @Override
            public boolean apply(long k) {
                return !c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final LongPredicate predicate) {
        return this.removeAll(new LongPredicate(){

            @Override
            public boolean apply(long value2) {
                return !predicate.apply(value2);
            }
        });
    }

    @Override
    public long[] toArray() {
        long[] array2 = new long[this.size()];
        int i = 0;
        for (LongCursor c : this) {
            array2[i++] = c.value;
        }
        return array2;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

