/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.IntCollection;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import java.util.Arrays;

abstract class AbstractIntCollection
implements IntCollection {
    AbstractIntCollection() {
    }

    @Override
    public int removeAll(final IntLookupContainer c) {
        return this.removeAll(new IntPredicate(){

            @Override
            public boolean apply(int k) {
                return c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final IntLookupContainer c) {
        return this.removeAll(new IntPredicate(){

            @Override
            public boolean apply(int k) {
                return !c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final IntPredicate predicate) {
        return this.removeAll(new IntPredicate(){

            @Override
            public boolean apply(int value2) {
                return !predicate.apply(value2);
            }
        });
    }

    @Override
    public int[] toArray() {
        int[] array2 = new int[this.size()];
        int i = 0;
        for (IntCursor c : this) {
            array2[i++] = c.value;
        }
        return array2;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

