/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.FloatCollection;
import com.carrotsearch.hppc.FloatLookupContainer;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import java.util.Arrays;

abstract class AbstractFloatCollection
implements FloatCollection {
    AbstractFloatCollection() {
    }

    @Override
    public int removeAll(final FloatLookupContainer c) {
        return this.removeAll(new FloatPredicate(){

            @Override
            public boolean apply(float k) {
                return c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final FloatLookupContainer c) {
        return this.removeAll(new FloatPredicate(){

            @Override
            public boolean apply(float k) {
                return !c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final FloatPredicate predicate) {
        return this.removeAll(new FloatPredicate(){

            @Override
            public boolean apply(float value2) {
                return !predicate.apply(value2);
            }
        });
    }

    @Override
    public float[] toArray() {
        float[] array2 = new float[this.size()];
        int i = 0;
        for (FloatCursor c : this) {
            array2[i++] = c.value;
        }
        return array2;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

