/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.DoubleCollection;
import com.carrotsearch.hppc.DoubleLookupContainer;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import java.util.Arrays;

abstract class AbstractDoubleCollection
implements DoubleCollection {
    AbstractDoubleCollection() {
    }

    @Override
    public int removeAll(final DoubleLookupContainer c) {
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double k) {
                return c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final DoubleLookupContainer c) {
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double k) {
                return !c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final DoublePredicate predicate) {
        return this.removeAll(new DoublePredicate(){

            @Override
            public boolean apply(double value2) {
                return !predicate.apply(value2);
            }
        });
    }

    @Override
    public double[] toArray() {
        double[] array2 = new double[this.size()];
        int i = 0;
        for (DoubleCursor c : this) {
            array2[i++] = c.value;
        }
        return array2;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

