/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.JArrayType;
import ch.epfl.lamp.fjbg.JMethodType;
import ch.epfl.lamp.fjbg.JObjectType;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

public abstract class JType {
    public static final int T_BOOLEAN = 4;
    public static final int T_CHAR = 5;
    public static final int T_FLOAT = 6;
    public static final int T_DOUBLE = 7;
    public static final int T_BYTE = 8;
    public static final int T_SHORT = 9;
    public static final int T_INT = 10;
    public static final int T_LONG = 11;
    public static final int T_VOID = 12;
    public static final int T_ARRAY = 13;
    public static final int T_OBJECT = 14;
    public static final int T_UNKNOWN = 15;
    public static final int T_ADDRESS = 16;
    public static final int T_REFERENCE = 17;
    public static final JType[] EMPTY_ARRAY = new JType[0];
    public static JType VOID = new JType(){

        @Override
        public int getSize() {
            return 0;
        }

        @Override
        public String getSignature() {
            return "V";
        }

        @Override
        public int getTag() {
            return 12;
        }

        @Override
        public String toString() {
            return "void";
        }

        @Override
        public boolean isCompatibleWith(JType other) {
            throw new UnsupportedOperationException("type VOID is no real data type therefore cannot be assigned to " + other.toString());
        }
    };
    public static JType BOOLEAN = new JType(){

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public String getSignature() {
            return "Z";
        }

        @Override
        public int getTag() {
            return 4;
        }

        @Override
        public String toString() {
            return "boolean";
        }

        @Override
        public boolean isValueType() {
            return true;
        }

        @Override
        public boolean isCompatibleWith(JType other) {
            return other == BOOLEAN || other == INT || other == BYTE || other == CHAR || other == SHORT;
        }
    };
    public static JType BYTE = new JType(){

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public String getSignature() {
            return "B";
        }

        @Override
        public int getTag() {
            return 8;
        }

        @Override
        public String toString() {
            return "byte";
        }

        @Override
        public boolean isValueType() {
            return true;
        }

        @Override
        public boolean isCompatibleWith(JType other) {
            return other == BOOLEAN || other == INT || other == BYTE || other == CHAR || other == SHORT;
        }
    };
    public static JType CHAR = new JType(){

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public String getSignature() {
            return "C";
        }

        @Override
        public int getTag() {
            return 5;
        }

        @Override
        public String toString() {
            return "char";
        }

        @Override
        public boolean isValueType() {
            return true;
        }

        @Override
        public boolean isCompatibleWith(JType other) {
            return other == BOOLEAN || other == INT || other == BYTE || other == CHAR || other == SHORT;
        }
    };
    public static JType SHORT = new JType(){

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public String getSignature() {
            return "S";
        }

        @Override
        public int getTag() {
            return 9;
        }

        @Override
        public String toString() {
            return "short";
        }

        @Override
        public boolean isValueType() {
            return true;
        }

        @Override
        public boolean isCompatibleWith(JType other) {
            return other == BOOLEAN || other == INT || other == BYTE || other == CHAR || other == SHORT;
        }
    };
    public static JType INT = new JType(){

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public String getSignature() {
            return "I";
        }

        @Override
        public int getTag() {
            return 10;
        }

        @Override
        public String toString() {
            return "int";
        }

        @Override
        public boolean isValueType() {
            return true;
        }

        @Override
        public boolean isCompatibleWith(JType other) {
            return other == BOOLEAN || other == INT || other == BYTE || other == CHAR || other == SHORT;
        }
    };
    public static JType FLOAT = new JType(){

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public String getSignature() {
            return "F";
        }

        @Override
        public int getTag() {
            return 6;
        }

        @Override
        public String toString() {
            return "float";
        }

        @Override
        public boolean isValueType() {
            return true;
        }

        @Override
        public boolean isCompatibleWith(JType other) {
            return other == FLOAT;
        }
    };
    public static JType LONG = new JType(){

        @Override
        public int getSize() {
            return 2;
        }

        @Override
        public String getSignature() {
            return "J";
        }

        @Override
        public int getTag() {
            return 11;
        }

        @Override
        public String toString() {
            return "long";
        }

        @Override
        public boolean isValueType() {
            return true;
        }

        @Override
        public boolean isCompatibleWith(JType other) {
            return other == LONG;
        }
    };
    public static JType DOUBLE = new JType(){

        @Override
        public int getSize() {
            return 2;
        }

        @Override
        public String getSignature() {
            return "D";
        }

        @Override
        public int getTag() {
            return 7;
        }

        @Override
        public String toString() {
            return "double";
        }

        @Override
        public boolean isValueType() {
            return true;
        }

        @Override
        public boolean isCompatibleWith(JType other) {
            return other == DOUBLE;
        }
    };
    public static JType REFERENCE = new JType(){

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public String getSignature() {
            throw new UnsupportedOperationException("type REFERENCE is no real data type and therefore has no signature");
        }

        @Override
        public int getTag() {
            return 17;
        }

        @Override
        public String toString() {
            return "<reference>";
        }

        @Override
        public boolean isCompatibleWith(JType other) {
            throw new UnsupportedOperationException("type REFERENCE is no real data type and therefore cannot be assigned to " + other.toString());
        }
    };
    public static JType ADDRESS = new JType(){

        @Override
        public int getSize() {
            return 1;
        }

        @Override
        public String getSignature() {
            throw new UnsupportedOperationException("type ADDRESS is no usable data type and therefore has no signature");
        }

        @Override
        public int getTag() {
            return 16;
        }

        @Override
        public String toString() {
            return "<address>";
        }

        @Override
        public boolean isCompatibleWith(JType other) {
            return other == ADDRESS;
        }
    };
    public static JType UNKNOWN = new JType(){

        @Override
        public int getSize() {
            throw new UnsupportedOperationException("type UNKNOWN is no real data type and therefore has no size");
        }

        @Override
        public String getSignature() {
            throw new UnsupportedOperationException("type UNKNOWN is no real data type and therefore has no signature");
        }

        @Override
        public int getTag() {
            return 15;
        }

        @Override
        public String toString() {
            return "<unknown>";
        }

        @Override
        public boolean isCompatibleWith(JType other) {
            throw new UnsupportedOperationException("type UNKNOWN is no real data type and therefore cannot be assigned to " + other.toString());
        }
    };

    public abstract int getSize();

    public abstract String getSignature();

    public abstract int getTag();

    public abstract String toString();

    public abstract boolean isCompatibleWith(JType var1);

    public boolean isValueType() {
        return false;
    }

    public boolean isObjectType() {
        return false;
    }

    public boolean isArrayType() {
        return false;
    }

    public boolean isReferenceType() {
        return false;
    }

    protected static JType parseSig(StringReader s2) throws IOException {
        int nextChar = s2.read();
        if (nextChar == -1) {
            throw new IllegalArgumentException();
        }
        switch ((char)nextChar) {
            case 'V': {
                return VOID;
            }
            case 'Z': {
                return BOOLEAN;
            }
            case 'B': {
                return BYTE;
            }
            case 'C': {
                return CHAR;
            }
            case 'S': {
                return SHORT;
            }
            case 'I': {
                return INT;
            }
            case 'F': {
                return FLOAT;
            }
            case 'J': {
                return LONG;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'L': {
                StringBuffer className2 = new StringBuffer();
                while ((nextChar = s2.read()) != -1 && nextChar != 59) {
                    className2.append((char)(nextChar == 47 ? 58 : (char)nextChar));
                }
                if (nextChar != 59) {
                    throw new IllegalArgumentException();
                }
                return new JObjectType(className2.toString());
            }
            case '[': {
                JType elemType = JType.parseSig(s2);
                return new JArrayType(elemType);
            }
            case '(': {
                ArrayList<JType> argTps = new ArrayList<JType>();
                while (true) {
                    s2.mark(1);
                    nextChar = s2.read();
                    if (nextChar == -1 || nextChar == 41) break;
                    s2.reset();
                    argTps.add(JType.parseSig(s2));
                }
                if (nextChar != 41) {
                    throw new IllegalArgumentException("a");
                }
                JType[] argTpsA = argTps.toArray(new JType[argTps.size()]);
                JType returnType = JType.parseSig(s2);
                return new JMethodType(returnType, argTpsA);
            }
        }
        throw new IllegalArgumentException();
    }

    public static JType parseSignature(String signature2) {
        try {
            StringReader sigReader = new StringReader(signature2);
            JType parsed = JType.parseSig(sigReader);
            if (sigReader.read() != -1) {
                throw new IllegalArgumentException();
            }
            return parsed;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("invalid signature " + signature2);
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    public static int getTotalSize(JType[] types2) {
        int size2 = 0;
        for (int i = 0; i < types2.length; ++i) {
            size2 += types2[i].getSize();
        }
        return size2;
    }

    protected JType() {
    }

    protected static String tagToString(int tag) {
        switch (tag) {
            case 4: {
                return "boolean";
            }
            case 5: {
                return "char";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
            case 8: {
                return "byte";
            }
            case 9: {
                return "short";
            }
            case 10: {
                return "int";
            }
            case 11: {
                return "long";
            }
            case 12: {
                return "void";
            }
            case 13: {
                return "[]";
            }
            case 14: {
                return "Object";
            }
            case 15: {
                return "<unknown>";
            }
            case 16: {
                return "<address>";
            }
        }
        return String.valueOf(tag);
    }
}

