/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import ch.epfl.lamp.fjbg.JConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class JInnerClassesAttribute
extends JAttribute {
    private JConstantPool pool;
    private Map entries = new LinkedHashMap();

    public JInnerClassesAttribute(FJBGContext context, JClass clazz2) {
        super(context, clazz2);
        this.pool = clazz2.pool;
    }

    public JInnerClassesAttribute(FJBGContext context, JClass clazz2, Object owner, String name2, int size2, DataInputStream stream) throws IOException {
        super(context, clazz2, name2);
        this.pool = clazz2.pool;
        String inner2 = null;
        int count2 = stream.readShort();
        for (int i = 0; i < count2; ++i) {
            short innerIdx = stream.readShort();
            short outerIdx = stream.readShort();
            short nameIdx = stream.readShort();
            short flags2 = stream.readShort();
            inner2 = this.pool.lookupClass(innerIdx);
            this.entries.put(inner2, new Entry(innerIdx, outerIdx, nameIdx, (int)flags2));
        }
        assert (name2.equals(this.getName()));
    }

    public void addEntry(String inner2, String outer, String name2, int flags2) {
        int innerIdx = this.pool.addClass(inner2);
        int outerIdx = 0;
        if (outer != null) {
            outerIdx = this.pool.addClass(outer);
        }
        int nameIdx = 0;
        if (name2 != null) {
            nameIdx = this.pool.addUtf8(name2);
        }
        Entry e = new Entry(innerIdx, outerIdx, nameIdx, flags2);
        if (this.entries.containsKey(inner2)) {
            Entry other = (Entry)this.entries.get(inner2);
            assert (other.outerInfo == e.outerInfo && other.originalName == e.originalName && other.innerFlags == e.innerFlags) : inner2 + " already declared as " + other;
        } else {
            this.entries.put(inner2, e);
        }
    }

    @Override
    public String getName() {
        return "InnerClasses";
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("  InnerClass: ");
        for (Entry e : this.entries.values()) {
            buf.append("\n   ");
            buf.append(e.innerFlagsToString());
            buf.append("#");
            if (e.originalName != 0) {
                buf.append(e.originalName);
                buf.append("= #");
            }
            buf.append(e.innerInfo);
            if (e.outerInfo != 0) {
                buf.append(" of #");
                buf.append(e.outerInfo);
            }
            buf.append("; //");
            if (e.originalName != 0) {
                buf.append(this.pool.lookupUtf8(e.originalName));
                buf.append("=");
            }
            buf.append("class ");
            buf.append(this.pool.lookupClass(e.innerInfo));
            if (e.outerInfo == 0) continue;
            buf.append(" of class ");
            buf.append(this.pool.lookupClass(e.outerInfo));
        }
        buf.append("\n");
        return buf.toString();
    }

    @Override
    protected int getSize() {
        return 2 + this.entries.size() * 8;
    }

    @Override
    protected void writeContentsTo(DataOutputStream stream) throws IOException {
        stream.writeShort(this.entries.size());
        for (Entry e : this.entries.values()) {
            stream.writeShort(e.innerInfo);
            stream.writeShort(e.outerInfo);
            stream.writeShort(e.originalName);
            stream.writeShort(e.innerFlags);
        }
    }

    private class Entry {
        int innerInfo;
        int outerInfo;
        int originalName;
        int innerFlags;

        public Entry(int iI, int oI, int oN, int f2) {
            this.innerInfo = iI;
            this.outerInfo = oI;
            this.originalName = oN;
            this.innerFlags = f2;
        }

        public Entry(String innerClass, String outerClass, String name2, int flags2) {
            this(jInnerClassesAttribute.pool.addClass(innerClass), jInnerClassesAttribute.pool.addClass(outerClass), jInnerClassesAttribute.pool.addUtf8(name2), flags2);
        }

        public boolean equals(Object other) {
            if (other instanceof Entry) {
                Entry otherEntry = (Entry)other;
                return otherEntry.innerInfo == this.innerInfo;
            }
            return false;
        }

        public String innerFlagsToString() {
            StringBuffer buf = new StringBuffer();
            if (this.isPublic()) {
                buf.append("public ");
            } else if (this.isProtected()) {
                buf.append("protected ");
            } else if (this.isPrivate()) {
                buf.append("private ");
            }
            if (this.isAbstract()) {
                buf.append("abstract ");
            } else if (this.isFinal()) {
                buf.append("final ");
            }
            return buf.toString();
        }

        private boolean isPublic() {
            return (this.innerFlags & 1) != 0;
        }

        private boolean isPrivate() {
            return (this.innerFlags & 2) != 0;
        }

        private boolean isProtected() {
            return (this.innerFlags & 4) != 0;
        }

        private boolean isStatic() {
            return (this.innerFlags & 8) != 0;
        }

        private boolean isFinal() {
            return (this.innerFlags & 0x10) != 0;
        }

        private boolean isAbstract() {
            return (this.innerFlags & 0x400) != 0;
        }
    }
}

