/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.ConstructorInfo;
import ch.epfl.lamp.compiler.msil.CustomAttributeProvider;
import ch.epfl.lamp.compiler.msil.EventInfo;
import ch.epfl.lamp.compiler.msil.FieldInfo;
import ch.epfl.lamp.compiler.msil.GenericParamAndConstraints;
import ch.epfl.lamp.compiler.msil.MethodBase;
import ch.epfl.lamp.compiler.msil.MethodInfo;
import ch.epfl.lamp.compiler.msil.PEFile;
import ch.epfl.lamp.compiler.msil.PEModule;
import ch.epfl.lamp.compiler.msil.ParameterInfo;
import ch.epfl.lamp.compiler.msil.PropertyInfo;
import ch.epfl.lamp.compiler.msil.Type;
import ch.epfl.lamp.compiler.msil.util.PECustomMod;
import ch.epfl.lamp.compiler.msil.util.Signature;
import ch.epfl.lamp.compiler.msil.util.Table;
import java.util.ArrayList;

final class PEType
extends Type
implements Signature {
    final PEFile file;
    final int definingRow;
    final int methodListBeg;
    final int methodListEnd;
    protected MethodBase[] methoddefs;

    PEType(PEModule module2, int attributes2, String fullName2, Type declType, int auxAttr, PEFile file, int definingRow) {
        super(module2, attributes2, fullName2, null, null, declType, auxAttr);
        this.file = file;
        this.definingRow = definingRow;
        this.methodListBeg = file.TypeDef((int)definingRow).MethodList;
        this.methodListEnd = definingRow < file.TypeDef.rows ? file.TypeDef((int)(definingRow + 1)).MethodList : file.MethodDef.rows + 1;
    }

    @Override
    protected void loadBaseType() {
        Table.TypeDef type = this.file.TypeDef(this.definingRow);
        this.baseType = type.Extends == 0 ? null : ((PEModule)this.Module).getTypeDefOrRef(type.Extends);
    }

    @Override
    protected void loadFields() {
        ArrayList<PEFieldInfo> fields = new ArrayList<PEFieldInfo>();
        int fieldListBeg = this.file.TypeDef((int)this.definingRow).FieldList;
        int fieldListEnd = this.file.FieldDef.rows + 1;
        if (this.definingRow < this.file.TypeDef.rows) {
            fieldListEnd = this.file.TypeDef((int)(this.definingRow + 1)).FieldList;
        }
        for (int row = fieldListBeg; row < fieldListEnd; ++row) {
            int frow = this.file.FieldTrans.rows == 0 ? row : this.file.FieldTrans((int)row).Field;
            int attrs = this.file.FieldDef((int)frow).Flags;
            String name2 = this.file.FieldDef.getName();
            PEFile.Sig sig = this.file.FieldDef.getSignature();
            PECustomMod pecmod = sig.decodeFieldType();
            Object val = null;
            Table.Constant consts = this.file.Constant;
            for (int i = 1; i <= consts.rows; ++i) {
                consts.readRow(i);
                int tableId = Table.getTableId(1, consts.Parent);
                int refRow = consts.Parent >> Table.NoBits[1];
                if (tableId != 4 || refRow != frow) continue;
                val = consts.getValue();
            }
            PEFieldInfo field2 = new PEFieldInfo(row, name2, attrs, pecmod, val);
            if (field2.Name.equals("value__") && field2.IsSpecialName()) {
                assert (this.underlyingType == null) : this.underlyingType.toString();
                this.underlyingType = field2.FieldType;
            }
            fields.add(field2);
        }
        this.fields = fields.toArray(FieldInfo.EMPTY_ARRAY);
        fields.clear();
    }

    protected MethodInfo getMethod(int n) {
        return (MethodInfo)this.methoddefs[n - this.methodListBeg];
    }

    @Override
    protected void loadMethods() {
        this.methoddefs = new MethodBase[this.methodListEnd - this.methodListBeg];
        ArrayList methods2 = new ArrayList();
        ArrayList<MethodBase> constrs = new ArrayList<MethodBase>();
        PEModule pemodule = (PEModule)this.Module;
        for (int row = this.methodListBeg; row < this.methodListEnd; ++row) {
            int i;
            int mrow = this.file.MethodTrans.rows == 0 ? row : this.file.MethodTrans((int)row).Method;
            int attrs = this.file.MethodDef((int)mrow).Flags;
            String name2 = this.file.MethodDef.getName();
            PEFile.Sig sig = this.file.MethodDef.getSignature();
            int callConv = sig.readByte();
            if ((callConv & 0x1F) == 16) {
                int genParamCount = sig.decodeInt();
            }
            int paramCount = sig.decodeInt();
            Type retType = sig.decodeRetType();
            Type[] paramType = new Type[paramCount];
            for (int i2 = 0; i2 < paramCount; ++i2) {
                paramType[i2] = sig.decodeParamType();
            }
            ParameterInfo[] params2 = new ParameterInfo[paramCount];
            int paramListBeg = this.file.MethodDef.ParamList;
            int paramListEnd = paramListBeg + paramCount;
            if (paramListEnd > this.file.ParamDef.rows) {
                paramListEnd = this.file.ParamDef.rows + 1;
            }
            for (i = paramListBeg; i < paramListEnd; ++i) {
                int pattr = this.file.ParamDef((int)i).Flags;
                String paramName = this.file.ParamDef.getName();
                int seq = this.file.ParamDef.Sequence;
                if (seq == 0) continue;
                params2[seq - 1] = new ParameterInfo(paramName, paramType[seq - 1], pattr, seq - 1);
            }
            for (i = 0; i < params2.length; ++i) {
                if (params2[i] != null) continue;
                params2[i] = new ParameterInfo(null, paramType[i], 0, 0);
            }
            MethodBase method = null;
            if ((attrs & 0x800) != 0 && (attrs & 0x1000) != 0 && (name2.equals(".ctor") || name2.equals(".cctor"))) {
                method = new PEConstructorInfo(row, attrs, params2);
            } else {
                method = new PEMethodInfo(row, name2, attrs, retType, params2);
                int[] mvarIdxes = this.file.GenericParam.getMVarIdxes(row);
                for (int i3 = 0; i3 < mvarIdxes.length; ++i3) {
                    GenericParamAndConstraints mvarAndConstraints = pemodule.getTypeConstraints(mvarIdxes[i3]);
                    ((PEMethodInfo)method).addMVar(mvarAndConstraints);
                }
            }
            (method.IsConstructor() ? constrs : methods2).add(method);
            this.methoddefs[row - this.methodListBeg] = method;
        }
        this.constructors = constrs.toArray(ConstructorInfo.EMPTY_ARRAY);
        this.methods = methods2.toArray(MethodInfo.EMPTY_ARRAY);
        constrs.clear();
        methods2.clear();
    }

    @Override
    protected void loadProperties() {
        Table.PropertyMap pmap = this.file.PropertyMap;
        if (pmap == null) {
            this.properties = PropertyInfo.EMPTY_ARRAY;
            return;
        }
        Table.PropertyDef pdef = this.file.PropertyDef;
        int propListBeg = -1;
        int propListEnd = pdef.rows + 1;
        for (int i = 1; i <= pmap.rows; ++i) {
            pmap.readRow(i);
            if (pmap.Parent != this.definingRow) continue;
            propListBeg = pmap.PropertyList;
            if (i >= pmap.rows) break;
            pmap.readRow(i + 1);
            propListEnd = pmap.PropertyList;
            break;
        }
        if (propListBeg < 0) {
            this.properties = PropertyInfo.EMPTY_ARRAY;
            return;
        }
        ArrayList<PEPropertyInfo> properties2 = new ArrayList<PEPropertyInfo>();
        for (int i = propListBeg; i < propListEnd; ++i) {
            pdef.readRow(i);
            PEFile.Sig sig = pdef.getSignature();
            int b = sig.readByte();
            int paramCount = sig.readByte();
            assert ((b &= 0xFFFFFFDF) == 8);
            Type propType = sig.decodeType();
            int index2 = Table.encodeIndex(i, 6, 23);
            Table.MethodSemantics msem = this.file.MethodSemantics;
            MethodInfo getter2 = null;
            MethodInfo setter2 = null;
            for (int j = 1; j <= msem.rows; ++j) {
                msem.readRow(j);
                if (msem.Association != index2) continue;
                if (msem.isGetter()) {
                    getter2 = this.getMethod(msem.Method);
                    continue;
                }
                if (msem.isSetter()) {
                    setter2 = this.getMethod(msem.Method);
                    continue;
                }
                System.err.println("PEType.loadProperties(): !?!");
            }
            properties2.add(new PEPropertyInfo(i, pdef.getName(), (short)pdef.Flags, propType, getter2, setter2));
        }
        this.properties = properties2.toArray(PropertyInfo.EMPTY_ARRAY);
    }

    @Override
    protected void loadEvents() {
        Table.EventMap emap = this.file.EventMap;
        if (emap == null) {
            this.events = EventInfo.EMPTY_ARRAY;
            return;
        }
        Table.EventDef edef = this.file.EventDef;
        int eventListBeg = -1;
        int eventListEnd = edef.rows + 1;
        for (int i = 1; i <= emap.rows; ++i) {
            emap.readRow(i);
            if (emap.Parent != this.definingRow) continue;
            eventListBeg = emap.EventList;
            if (i >= emap.rows) break;
            emap.readRow(i + 1);
            eventListEnd = emap.EventList;
            break;
        }
        if (eventListBeg < 0) {
            this.events = EventInfo.EMPTY_ARRAY;
            return;
        }
        ArrayList<PEEventInfo> events2 = new ArrayList<PEEventInfo>();
        Table.MethodSemantics msem = this.file.MethodSemantics;
        for (int i = eventListBeg; i < eventListEnd; ++i) {
            edef.readRow(i);
            Type handler = ((PEModule)this.Module).getTypeDefOrRef(edef.EventType);
            int index2 = Table.encodeIndex(i, 6, 20);
            MethodInfo add2 = null;
            MethodInfo remove2 = null;
            for (int j = 1; j <= msem.rows; ++j) {
                msem.readRow(j);
                if (msem.Association != index2) continue;
                if (msem.isAddOn()) {
                    add2 = this.getMethod(msem.Method);
                    continue;
                }
                if (!msem.isRemoveOn()) continue;
                remove2 = this.getMethod(msem.Method);
            }
            events2.add(new PEEventInfo(i, edef.getName(), (short)edef.EventFlags, handler, add2, remove2));
        }
        this.events = events2.toArray(EventInfo.EMPTY_ARRAY);
    }

    @Override
    protected void loadNestedTypes() {
        ArrayList<Type> nested2 = new ArrayList<Type>();
        for (int i = 1; i <= this.file.NestedClass.rows; ++i) {
            this.file.NestedClass.readRow(i);
            if (this.file.NestedClass.EnclosingClass != this.definingRow) continue;
            nested2.add(((PEModule)this.Module).getTypeDef(this.file.NestedClass.NestedClass));
        }
        this.nestedTypes = nested2.toArray(Type.EmptyTypes);
    }

    @Override
    protected void loadInterfaces() {
        this.interfaces = Type.EmptyTypes;
        int index2 = this.file.InterfaceImpl.findType(this.definingRow);
        if (index2 > 0) {
            ArrayList<Type> ifaces = new ArrayList<Type>();
            for (int i = index2; i <= this.file.InterfaceImpl.rows; ++i) {
                this.file.InterfaceImpl.readRow(i);
                if (this.file.InterfaceImpl.Class != this.definingRow) break;
                ifaces.add(((PEModule)this.Module).getTypeDefOrRef(this.file.InterfaceImpl.Interface));
            }
            this.interfaces = ifaces.toArray(new Type[ifaces.size()]);
        }
    }

    @Override
    protected void loadCustomAttributes(Type attributeType) {
        this.initAttributes(this, this.definingRow, 2, attributeType);
    }

    private void initAttributes(CustomAttributeProvider cap, int definingRow, int sourceTableId, Type attributeType) {
        ((PEModule)this.Module).initAttributes(cap, definingRow, sourceTableId, attributeType);
    }

    private class PEEventInfo
    extends EventInfo {
        private final int definingRow;

        public PEEventInfo(int row, String name2, short attrs, Type handler, MethodInfo add2, MethodInfo remove2) {
            super(name2, PEType.this, attrs, handler, add2, remove2);
            this.definingRow = row;
        }

        @Override
        protected void loadCustomAttributes(Type attributeType) {
            PEType.this.initAttributes(this, this.definingRow, 20, attributeType);
        }
    }

    private class PEPropertyInfo
    extends PropertyInfo {
        private final int definingRow;

        public PEPropertyInfo(int row, String name2, short attrs, Type propType, MethodInfo getter2, MethodInfo setter2) {
            super(name2, PEType.this, attrs, propType, getter2, setter2);
            this.definingRow = row;
        }

        @Override
        protected void loadCustomAttributes(Type attributeType) {
            PEType.this.initAttributes(this, this.definingRow, 23, attributeType);
        }
    }

    private class PEConstructorInfo
    extends ConstructorInfo {
        private final int definingRow;

        public PEConstructorInfo(int row, int attrs, ParameterInfo[] params2) {
            super((Type)PEType.this, attrs, params2);
            this.definingRow = row;
        }

        @Override
        protected void loadCustomAttributes(Type attributeType) {
            PEType.this.initAttributes(this, this.definingRow, 6, attributeType);
        }
    }

    private class PEMethodInfo
    extends MethodInfo {
        private final int definingRow;

        public PEMethodInfo(int row, String name2, int attrs, Type retType, ParameterInfo[] params2) {
            super(name2, (Type)PEType.this, attrs, retType, params2);
            this.definingRow = row;
        }

        @Override
        protected void loadCustomAttributes(Type attributeType) {
            PEType.this.initAttributes(this, this.definingRow, 6, attributeType);
        }
    }

    private class PEFieldInfo
    extends FieldInfo {
        private final int definingRow;

        public PEFieldInfo(int definingRow, String name2, int attrs, PECustomMod pecmod, Object value2) {
            super(name2, PEType.this, attrs, pecmod, value2);
            this.definingRow = definingRow;
        }

        @Override
        protected void loadCustomAttributes(Type attributeType) {
            PEType.this.initAttributes(this, this.definingRow, 4, attributeType);
        }
    }
}

