/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.Assembly;
import ch.epfl.lamp.compiler.msil.AssemblyName;
import ch.epfl.lamp.compiler.msil.PEFile;
import ch.epfl.lamp.compiler.msil.PEModule;
import ch.epfl.lamp.compiler.msil.Type;
import ch.epfl.lamp.compiler.msil.util.Table;
import java.io.File;

final class PEAssembly
extends Assembly {
    private final PEFile pefile;
    private PEModule mainModule;

    public PEAssembly(PEFile pefile, AssemblyName an) {
        super(an, true);
        this.pefile = pefile;
        String name2 = pefile.ModuleDef(1).getName();
        this.mainModule = new PEModule(pefile, 1, name2, (Assembly)this);
        this.addModule(name2, this.mainModule);
    }

    @Override
    protected void loadModules() {
        File parentDir = this.pefile.getParentFile();
        Table.FileDef fd = this.pefile.FileDef;
        for (int row = 1; row <= fd.rows; ++row) {
            fd.readRow(row);
            String filename = fd.getName();
            File f2 = new File(parentDir, filename);
            PEFile pe = Assembly.getPEFile(f2);
            if (pe == null && (pe = Assembly.getPEFile(f2 = new File(filename))) == null) continue;
            String name2 = pe.ModuleDef(1).getName();
            PEModule module2 = new PEModule(pe, 1, name2, (Assembly)this);
            this.addModule(name2, module2);
        }
    }

    @Override
    public File getFile() {
        return this.pefile.getUnderlyingFile();
    }

    @Override
    protected void loadCustomAttributes(Type attributeType) {
        this.initModules();
        this.mainModule.initAttributes(this, 1, 32, attributeType);
    }
}

