/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;

public class FnSubsequence
extends Function {
    public FnSubsequence() {
        super(new QName("subsequence"), 2, 3);
    }

    @Override
    public ResultSequence evaluate(Collection args) throws DynamicError {
        return FnSubsequence.subsequence(args);
    }

    public static ResultSequence subsequence(Collection args) throws DynamicError {
        AnyType at;
        ResultSequence rs = ResultSequenceFactory.create_new();
        Iterator citer = args.iterator();
        ResultSequence seq = (ResultSequence)citer.next();
        if (seq.empty()) {
            return rs;
        }
        ResultSequence startLoc = (ResultSequence)citer.next();
        ResultSequence length = null;
        if (citer.hasNext()) {
            length = (ResultSequence)citer.next();
        }
        if (!((at = startLoc.first()) instanceof NumericType)) {
            DynamicError.throw_type_error();
        }
        at = new XSDouble(at.string_value());
        int start = (int)((XSDouble)at).double_value();
        int effectiveNoItems = 0;
        if (length != null) {
            int len;
            if (length.size() != 1) {
                DynamicError.throw_type_error();
            }
            if (!((at = length.first()) instanceof NumericType)) {
                DynamicError.throw_type_error();
            }
            if ((len = (int)((XSDouble)(at = new XSDouble(at.string_value()))).double_value()) < 0) {
                DynamicError.throw_type_error();
            }
            if (start <= 0) {
                effectiveNoItems = start + len - 1;
                start = 1;
            } else {
                effectiveNoItems = len;
            }
        } else if (start <= 0) {
            start = 1;
            effectiveNoItems = seq.size();
        } else {
            effectiveNoItems = seq.size() - start + 1;
        }
        int pos = 1;
        int addedItems = 0;
        if (effectiveNoItems > 0) {
            ListIterator seqIter = seq.iterator();
            while (seqIter.hasNext()) {
                at = (AnyType)seqIter.next();
                if (start <= pos && addedItems < effectiveNoItems) {
                    rs.add(at);
                    ++addedItems;
                }
                ++pos;
            }
        }
        return rs;
    }
}

