/*
 * AddHeaderTemplate.java
 *
 * Brazil project web application toolkit,
 * export version: 2.1 
 * Copyright (c) 1999-2004 Sun Microsystems, Inc.
 *
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version 
 * 1.0 (the "License"). You may not use this file except in compliance with 
 * the License. A copy of the License is included as the file "license.terms",
 * and also available at http://www.sun.com/
 * 
 * The Original Code is from:
 *    Brazil project web application toolkit release 2.1.
 * The Initial Developer of the Original Code is: suhler.
 * Portions created by suhler are Copyright (C) Sun Microsystems, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s): cstevens, suhler.
 *
 * Version:  2.7
 * Created by suhler on 99/03/09
 * Last modified by suhler on 04/11/30 10:45:50
 */

package sunlabs.brazil.template;

import java.util.Enumeration;
import sunlabs.brazil.server.Server;
import sunlabs.brazil.server.FileHandler;

/**
 * Template class for adding arbitrary mime headers to a reply.
 * Add a header onto the response, removing the tag from the HTML.
 * <code>&lt;addheader name1=value1 name2=value2 ...&gt;</code>
 * where <code>name</code> is the name of an HTTP header, and
 * <code>value</code> is its value.  If no value is provided, then
 * the header is removed.  If multiple name/value pairs are provided, 
 * they are processed in arbitrary order.
 * <p>
 * Special headers.<br>
 * If a "location" header is added, the status code is automatically
 * set to "302".  If the value doesn't start with "http://" or
 * "https://", then the
 * value is turned into an absolute URL
 * by prepending the the hostname (and the path from the document
 * root if the value doesn't start with '/'.<br>
 * Removing location headers is ill-advised.
 * <p>
 * The special header <b>status</b> is used to set the status code.
 * <p>
 * If the attribute <code>nocontent</code> is present, the http header
 * status is set to <b>204 no content</b>.  This causes the browser to
 * ignore the contents of the page.
 * <p>
 * The values are subject to ${...} substitutions.
 * <br>Note:  Setting invalid headers will lead to unpredictable results,
 *
 * @author		Stephen Uhler
 * @version		@(#) AddHeaderTemplate.java 2.7@(#)
 */

public class AddHeaderTemplate extends Template {

    /**
     * Process the special <code>addheader</code> tag.
     */
    public void
    tag_addheader(RewriteContext hr) {
	Enumeration e = hr.keys();
	while (e.hasMoreElements()) {
	    String key = (String) e.nextElement();
	    String value = hr.get(key);
	    hr.request.log(Server.LOG_DIAGNOSTIC, hr.prefix +
	    	"addheader: " + key + ": " + value);
	    if (key.equals("nocontent")) {
		hr.request.setStatus(204);
	    } else if (key.equals("status")) {
		try {
		    hr.request.setStatus(Integer.decode(value).intValue());
		} catch (Exception ex) {
		   debug(hr,"Invalid status code" + ex.getMessage()); 
		}
	    } else if (value.equals("")) {
	        hr.request.responseHeaders.remove(key);
	    } else {
		if (key.equals("location")) {
		    hr.request.setStatus(302);
		    if (!(value.startsWith("http://") ||
			    value.startsWith("https://"))) {
			if (!value.startsWith("/")) {
			    // relative to currentl url
			    value = hr.request.url.substring(0,
				    hr.request.url.lastIndexOf("/")) + "/" +
				    value;
			}
			value =hr.request.serverUrl() + FileHandler.urlToPath(
				value);
		    }
	            hr.request.log(Server.LOG_DIAGNOSTIC, hr.prefix +
			"redirecting to: " + value);
		}
		hr.request.addHeader(key,value);
	    }
	}
	hr.killToken();
    }
}
