# Xalan-C++ extensions library

## Introduction

Extension functions provide a powerful mechanism for extending and
simplifying what you can do with an XLST processor like Xalan. With
input and contributions from the XML open-source developer community,
we are working on placing the most useful extensions in an extensions
library distributed with Xalan-C++. If you have ideas and/or
contributions you would like to make, please email the Xalan
Development Mailing List.

## EXSLT extensions

Xalan-C++ supports the [EXSLT](http://exslt.org/) initiative to provide
a set of standard extension functions to XSLT users. Xalan-C++ includes
beta implementations for functions in four of the EXSLT namespaces
(some are calls to extension already in the Xalan namespace).

The source files for the implementations are in the XalanEXSLT
subdirectory of the source tree. See

* [*XalanEXSLTCommonImpl.hpp*](https://github.com/apache/xalan-c/blob/master/src/xalanc/XalanEXSLT/XalanEXSLTCommonImpl.hpp)
* [*XalanEXSLTMathImpl.hpp*](https://github.com/apache/xalan-c/blob/master/src/xalanc/XalanEXSLT/XalanEXSLTMathImpl.hpp)
* [*XalanEXSLTSetImpl.hpp*](https://github.com/apache/xalan-c/blob/master/src/xalanc/XalanEXSLT/XalanEXSLTSetImpl.hpp)
* [*XalanEXSLTStringImpl.hpp*](https://github.com/apache/xalan-c/blob/master/src/xalanc/XalanEXSLT/XalanEXSLTStringImpl.hpp)
* [*XalanEXSLTDynamicImpl.hpp*](https://github.com/apache/xalan-c/blob/master/src/xalanc/XalanEXSLT/XalanEXSLTDynamicImpl.hpp)
* [*XalanEXSLTDateTimeImpl.hpp*](https://github.com/apache/xalan-c/blob/master/src/xalanc/XalanEXSLT/XalanEXSLTDateTimeImpl.hpp)

For the function specifications, see:

* [EXSLT common functions](http://www.exslt.org/exsl/exsl.html)
* [EXSLT math functions](http://www.exslt.org/math/math.html)
* [EXSLT set functions](http://www.exslt.org/set/set.html)
* [EXSLT string functions](http://www.exslt.org/str/str.html)
* [EXSLT dynamic functions](http://www.exslt.org/dyn/dyn.html)
* [EXSLT date-time functions](http://www.exslt.org/date/date.html)

Anyone who would like to participate in the Xalan-C++ initiative to
support EXSLT by testing these implementations or implementing other
EXSLT functions is more than welcome.  Please email the Xalan
Development Mailing List.

## Xalan namespace

We are placing the Xalan extension functions in the `XalanExtensions`
module and we have defined a namespace for this module: `http://xml.apache.org/xalan`

If you are calling Xalan-C++-supplied extensions, we recommend that you
define this namespace in your stylesheet element, and call the
extension using the namespace prefix that you have associated with that
namespace. That way, if we later reorganize how the Xalan-C++-supplied
extensions are stored, you won't have to modify your stylesheet.

For an example that uses this namespace, see
[Example with the nodeset extension function](#example-with-the-nodeset-extension-function).

## nodeset

Implemented in `FunctionNodeSet`, `nodeset (result-tree-fragment)`
casts a result tree fragment into a `node-set`.

Note: When you bind a variable to a template, rather than to the value
generated by a select expression, the data type of the variable is
result tree fragment. For more information, see
[Result Tree Fragments](http://www.w3.org/TR/xslt#section-Result-Tree-Fragments).

### Example with the nodeset extension function

The following stylesheet uses the `nodeset` extension function to cast
a result tree fragment into a `node-set` that can then be navigated in
standard XPath manner.  It uses the `http://xml.apache.org/xalan`
namespace to provide access to the `nodeset()` method in
`xml.apache.xalan.lib.Extensions`.

```xml
<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                   version="1.0"
                   xmlns:xalan="http://xml.apache.org/xalan"
                   exclude-result-prefixes="xalan">
<xsl:template match="/">
  <out>
	  <xsl:variable name="rtf">
      <docelem>
        <elem1>
          <elem1a>ELEMENT1A</elem1a>
          <elem1b>,ELEMENT1B</elem1b>
        </elem1>
        <elem2>
          <elem2a>ELEMENT2A</elem2a>
        </elem2>
      </docelem>
    </xsl:variable>
      <xsl:for-each select="xalan:nodeset($rtf)/docelem//*">
        <xsl:value-of select="name(.)"/><xsl:text>,</xsl:text>
      </xsl:for-each>
  </out>
</xsl:template>
</xsl:stylesheet>
```

The output of running this stylesheet (with any XML input source) is a
comma-delimited list of the element names in the `node-set`

```xml
<out>elem1,elem1a,elem1b,elem2,elem2a</out>
```

Note: For illustration purposes, the preceding stylesheet pays no
attention to the structure and content of the XML input document.
Instead, it processes the template (in the stylesheet) bound to the
variable named *rtf*.

## intersection

Implemented in `FunctionIntersection`,
`intersection (node-set1, node-set2)`
returns a `node-set` with all nodes that are in *node-set1* and in
*node-set2*.

## difference

Implemented in `FunctionDifference`, `difference(node-set1, node-set2)`
returns a `node-set` with the nodes in *node-set1* and not in
*node-set2*.

## distinct

Implemented in `FunctionDistinct`, `distinct (node-set)` returns a
`node-set` containing nodes with distinct string values. If more than
one node in the *node-set* contains the same text node value, distinct
only returns the first of these nodes that it finds.

## evaluate

Implemented in `FunctionEvaluate`, `evaluate (xpath-expression)`
returns the result of evaluating the *xpath-expression* in the current
XPath expression context (automatically passed in by the extension
mechanism).

Use the evaluation extension function when the value of the expression
is not known until run time.

## hasSameNodes

Implemented in `FunctionHasSameNodes`, `hasSameNodes(node-set1, node-set2)`
returns true if both *node-set1* and *node-set2* contain exactly the
same set of nodes.
