/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings;

import org.apache.wicket.authorization.IUnauthorizedResourceRequestListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.handler.ErrorCodeRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;

public class DefaultUnauthorizedResourceRequestListener
implements IUnauthorizedResourceRequestListener {
    @Override
    public void onUnauthorizedRequest(IResource resource, PageParameters parameters) {
        RequestCycle cycle = RequestCycle.get();
        if (cycle != null) {
            ErrorCodeRequestHandler handler = new ErrorCodeRequestHandler(403, this.createErrorMessage(resource, parameters));
            cycle.replaceAllRequestHandlers(handler);
        }
    }

    protected String createErrorMessage(IResource resource, PageParameters parameters) {
        return "The request to resource '" + resource + "' with parameters '" + parameters + "' cannot be authorized.";
    }
}

