/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.diff;

import java.util.List;
import org.apache.wicket.util.diff.Chunk;
import org.apache.wicket.util.diff.Delta;
import org.apache.wicket.util.diff.Diff;
import org.apache.wicket.util.diff.PatchFailedException;
import org.apache.wicket.util.diff.RevisionVisitor;

public class AddDelta
extends Delta {
    AddDelta() {
    }

    public AddDelta(int origpos, Chunk rev) {
        this.init(new Chunk(origpos, 0), rev);
    }

    @Override
    public void verify(List<Object> target) throws PatchFailedException {
        if (this.original.first() > target.size()) {
            throw new PatchFailedException("original.first() > target.size()");
        }
    }

    @Override
    public void applyTo(List<Object> target) {
        this.revised.applyAdd(this.original.first(), target);
    }

    @Override
    public void toString(StringBuilder s) {
        s.append(this.original.anchor());
        s.append("a");
        s.append(this.revised.rangeString());
        s.append(Diff.NL);
        this.revised.toString(s, "> ", Diff.NL);
    }

    @Override
    public void toRCSString(StringBuilder s, String EOL) {
        s.append("a");
        s.append(this.original.anchor());
        s.append(" ");
        s.append(this.revised.size());
        s.append(EOL);
        this.revised.toString(s, "", EOL);
    }

    @Override
    public void accept(RevisionVisitor visitor) {
        visitor.visit(this);
    }
}

