/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.template;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.wicket.Application;
import org.apache.wicket.core.util.resource.locator.ResourceStreamLocator;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.string.interpolator.MapVariableInterpolator;
import org.apache.wicket.util.template.TextTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageTextTemplate
extends TextTemplate {
    private static final Logger log = LoggerFactory.getLogger(PackageTextTemplate.class);
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_CONTENT_TYPE = "text";
    public static final String DEFAULT_ENCODING = null;
    private final StringBuilder buffer = new StringBuilder();
    private final Class<?> scope;
    private final String fileName;
    private String encoding;

    public PackageTextTemplate(Class<?> clazz, String fileName) {
        this(clazz, fileName, DEFAULT_CONTENT_TYPE);
    }

    public PackageTextTemplate(Class<?> clazz, String fileName, String contentType) {
        this(clazz, fileName, contentType, DEFAULT_ENCODING);
    }

    public PackageTextTemplate(Class<?> clazz, String fileName, String contentType, String encoding) {
        this(clazz, fileName, null, null, null, contentType, encoding);
    }

    public PackageTextTemplate(Class<?> clazz, String fileName, String style, String variation, Locale locale, String contentType, String encoding) {
        super(contentType);
        this.scope = clazz;
        this.fileName = fileName;
        this.encoding = encoding;
        this.setStyle(style);
        this.setVariation(variation);
        this.setLocale(locale);
    }

    @Override
    public void setStyle(String style) {
        if (!Objects.equals(style, this.getStyle())) {
            this.buffer.setLength(0);
        }
        super.setStyle(style);
    }

    @Override
    public void setLocale(Locale locale) {
        if (!Objects.equals(locale, this.getLocale())) {
            this.buffer.setLength(0);
        }
        super.setLocale(locale);
    }

    @Override
    public void setVariation(String variation) {
        if (!Objects.equals(variation, this.getVariation())) {
            this.buffer.setLength(0);
        }
        super.setVariation(variation);
    }

    public void setEncoding(String encoding) {
        if (!Objects.equals(encoding, this.encoding)) {
            this.buffer.setLength(0);
        }
        this.encoding = encoding == null ? DEFAULT_ENCODING : encoding;
    }

    private void load() {
        if (this.buffer.length() == 0) {
            String path = Packages.absolutePath(this.scope, this.fileName);
            Application app = Application.get();
            IResourceStream stream = app.getResourceSettings().getResourceStreamLocator().locate(this.scope, path, this.getStyle(), this.getVariation(), this.getLocale(), null, false);
            if (stream == null) {
                stream = new ResourceStreamLocator().locate(this.scope, path, this.getStyle(), this.getVariation(), this.getLocale(), null, false);
            }
            if (stream == null) {
                throw new IllegalArgumentException("resource " + this.fileName + " not found for scope " + this.scope + " (path = " + path + ")");
            }
            this.setLastModified(stream.lastModifiedTime());
            try {
                if (this.encoding != null) {
                    this.buffer.append(Streams.readString(stream.getInputStream(), this.encoding));
                } else {
                    this.buffer.append(Streams.readString(stream.getInputStream()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ResourceStreamNotFoundException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
    }

    @Override
    public String getString() {
        this.load();
        return this.buffer.toString();
    }

    @Override
    public final TextTemplate interpolate(Map<String, ?> variables) {
        if (variables != null) {
            this.load();
            String result = new MapVariableInterpolator(this.buffer.toString(), variables).toString();
            this.buffer.setLength(0);
            this.buffer.append(result);
        }
        return this;
    }
}

