package org.apache.dvsl;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import junit.framework.TestCase;
import junit.framework.Test;
import junit.framework.TestSuite;

import java.io.StringReader;
import java.io.StringWriter;

/**
 *  Tests some Xpath peculiarities
 *
 *  @author <a href="mailto:geirm@apache.org>Geir Magnusson Jr.</a>
 *  @version $Id: XPathTest.java 537999 2007-05-14 21:58:32Z cbrisson $
 *
 */
public class XPathTest extends TestCase
{
    public static Test suite()
    {
        return new TestSuite(XPathTest.class);
    }

    public XPathTest(String testName)
    {
        super(testName);
    }

    /**
     *  ensure we can match CDATA sections
     */
    public void testCDATA()
        throws Exception
    {
        String dvslstyle = "#match(\"text()\")$node.value()#end";
        String input = "<?xml version=\"1.0\"?><document><![CDATA[Hello from CDATA]]></document>";
        DVSL dvsl = new DVSL();

        /*
         *  register the stylesheet
         */

        dvsl.setStylesheet( new StringReader(dvslstyle) );

        /*
         *  render the document as a Reader
         */

        StringWriter sw = new StringWriter();

        dvsl.transform( new StringReader( input ), sw );

        assertTrue("First Test : " + sw.toString(),
                sw.toString().equals("Hello from CDATA"));
    }

    /**
     *  ensure that the Union is working
     */
    public void testUNION()
        throws Exception
    {
        String dvslstyle = "#match(\"p | document \")Matched#end";
        String input = "<?xml version=\"1.0\"?><document>document</document>";
        DVSL dvsl = new DVSL();

        /*
         *  register the stylesheet
         */

        dvsl.setStylesheet( new StringReader(dvslstyle) );

        /*
         *  render the document as a Reader
         */

        StringWriter sw = new StringWriter();

        dvsl.transform( new StringReader( input ), sw );

        assertTrue("First Test : " + sw.toString(),
               sw.toString().equals("Matched"));
    }

}
