/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.transaction;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.spring.transaction.TransactionContextHolder;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.ResourceTransactionManager;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HazelcastTransactionManager
extends AbstractPlatformTransactionManager
implements ResourceTransactionManager {
    private HazelcastInstance hazelcastInstance;

    public HazelcastTransactionManager(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public static TransactionContext getTransactionContext(HazelcastInstance hazelcastInstance) {
        TransactionContextHolder transactionContextHolder = (TransactionContextHolder)TransactionSynchronizationManager.getResource((Object)hazelcastInstance);
        if (transactionContextHolder == null) {
            throw new NoTransactionException("No TransactionContext with actual transaction available for current thread");
        }
        return transactionContextHolder.getContext();
    }

    public TransactionContext getTransactionContext() {
        return HazelcastTransactionManager.getTransactionContext(this.hazelcastInstance);
    }

    public Object getResourceFactory() {
        return this.hazelcastInstance;
    }

    protected Object doGetTransaction() throws org.springframework.transaction.TransactionException {
        HazelcastTransactionObject txObject = new HazelcastTransactionObject();
        TransactionContextHolder transactionContextHolder = (TransactionContextHolder)TransactionSynchronizationManager.getResource((Object)this.hazelcastInstance);
        if (transactionContextHolder != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found thread-bound TransactionContext [" + transactionContextHolder.getContext() + "]"));
            }
            txObject.setTransactionContextHolder(transactionContextHolder, false);
        }
        return txObject;
    }

    protected boolean isExistingTransaction(Object transaction) throws org.springframework.transaction.TransactionException {
        return ((HazelcastTransactionObject)transaction).hasTransaction();
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws org.springframework.transaction.TransactionException {
        HazelcastTransactionObject txObject = (HazelcastTransactionObject)transaction;
        try {
            if (txObject.getTransactionContextHolder() == null) {
                TransactionContext transactionContext = this.hazelcastInstance.newTransactionContext();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Opened new TransactionContext [" + transactionContext + "]"));
                }
                txObject.setTransactionContextHolder(new TransactionContextHolder(transactionContext), true);
            }
            txObject.getTransactionContextHolder().beginTransaction();
            if (txObject.isNewTransactionContextHolder()) {
                TransactionSynchronizationManager.bindResource((Object)this.hazelcastInstance, (Object)txObject.getTransactionContextHolder());
            }
        }
        catch (Throwable ex) {
            this.closeTransactionContextAfterFailedBegin(txObject);
            throw new CannotCreateTransactionException("Could not begin Hazelcast transaction", ex);
        }
    }

    private void closeTransactionContextAfterFailedBegin(HazelcastTransactionObject txObject) {
        if (txObject.isNewTransactionContextHolder()) {
            TransactionContext context = txObject.getTransactionContextHolder().getContext();
            try {
                context.rollbackTransaction();
            }
            catch (Throwable ex) {
                this.logger.debug((Object)"Could not rollback Hazelcast transaction after failed transaction begin", ex);
            }
            txObject.setTransactionContextHolder(null, false);
        }
    }

    protected void doCommit(DefaultTransactionStatus status) throws org.springframework.transaction.TransactionException {
        HazelcastTransactionObject txObject = (HazelcastTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Committing Hazelcast transaction on TransactionContext [" + txObject.getTransactionContextHolder().getContext() + "]"));
        }
        try {
            txObject.getTransactionContextHolder().getContext().commitTransaction();
        }
        catch (TransactionException ex) {
            throw new TransactionSystemException("Could not commit Hazelcast transaction", (Throwable)ex);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws org.springframework.transaction.TransactionException {
        HazelcastTransactionObject txObject = (HazelcastTransactionObject)status.getTransaction();
        txObject.setRollbackOnly(true);
    }

    protected void doRollback(DefaultTransactionStatus status) throws org.springframework.transaction.TransactionException {
        HazelcastTransactionObject txObject = (HazelcastTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)("Rolling back Hazelcast transaction on TransactionContext [" + txObject.getTransactionContextHolder().getContext() + "]"));
        }
        TransactionContext tx = txObject.getTransactionContextHolder().getContext();
        tx.rollbackTransaction();
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        HazelcastTransactionObject txObject = (HazelcastTransactionObject)transaction;
        if (txObject.isNewTransactionContextHolder()) {
            TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.hazelcastInstance);
        }
        txObject.getTransactionContextHolder().clear();
    }

    private static class HazelcastTransactionObject
    implements SmartTransactionObject {
        private TransactionContextHolder transactionContextHolder;
        private boolean newTransactionContextHolder;
        private boolean rollbackOnly;

        private HazelcastTransactionObject() {
        }

        void setRollbackOnly(boolean rollbackOnly) {
            this.rollbackOnly = rollbackOnly;
        }

        void setTransactionContextHolder(TransactionContextHolder transactionContextHolder, boolean newTransactionContextHolder) {
            this.transactionContextHolder = transactionContextHolder;
            this.newTransactionContextHolder = newTransactionContextHolder;
        }

        TransactionContextHolder getTransactionContextHolder() {
            return this.transactionContextHolder;
        }

        boolean isNewTransactionContextHolder() {
            return this.newTransactionContextHolder;
        }

        boolean hasTransaction() {
            return this.transactionContextHolder != null && this.transactionContextHolder.isTransactionActive();
        }

        public boolean isRollbackOnly() {
            return this.rollbackOnly;
        }

        public void flush() {
        }
    }
}

