/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;

public class LocaleUtils {
    public static Locale parse(String localeStr) {
        char c;
        boolean useUnderscoreAsSeparator = false;
        for (int i = 0; i < localeStr.length() && (c = localeStr.charAt(i)) != '-'; ++i) {
            if (c != '_') continue;
            useUnderscoreAsSeparator = true;
            break;
        }
        String[] parts = useUnderscoreAsSeparator ? localeStr.split("_", -1) : localeStr.split("-", -1);
        Locale locale = LocaleUtils.parseParts(parts);
        try {
            locale.getISO3Language();
        }
        catch (MissingResourceException e) {
            throw new IllegalArgumentException("Unknown language: " + parts[0], e);
        }
        try {
            locale.getISO3Country();
        }
        catch (MissingResourceException e) {
            throw new IllegalArgumentException("Unknown country: " + parts[1], e);
        }
        return locale;
    }

    private static Locale parseParts(String[] parts) {
        switch (parts.length) {
            case 3: {
                return new Locale(parts[0], parts[1], parts[2]);
            }
            case 2: {
                return new Locale(parts[0], parts[1]);
            }
            case 1: {
                if ("ROOT".equalsIgnoreCase(parts[0])) {
                    return Locale.ROOT;
                }
                return new Locale(parts[0]);
            }
        }
        throw new IllegalArgumentException("Locales can have at most 3 parts but got " + parts.length + ": " + Arrays.asList(parts));
    }
}

