/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

public class ListenerTimeouts {
    public static <Response> ActionListener<Response> wrapWithTimeout(ThreadPool threadPool, ActionListener<Response> listener, TimeValue timeout, String executor, String listenerName) {
        TimeoutableListener wrappedListener = new TimeoutableListener(listener, timeout, listenerName);
        wrappedListener.cancellable = threadPool.schedule(wrappedListener, timeout, executor);
        return wrappedListener;
    }

    private static class TimeoutableListener<Response>
    implements ActionListener<Response>,
    Runnable {
        private final AtomicBoolean isDone = new AtomicBoolean(false);
        private final ActionListener<Response> delegate;
        private final TimeValue timeout;
        private final String listenerName;
        private volatile Scheduler.ScheduledCancellable cancellable;

        private TimeoutableListener(ActionListener<Response> delegate, TimeValue timeout, String listenerName) {
            this.delegate = delegate;
            this.timeout = timeout;
            this.listenerName = listenerName;
        }

        @Override
        public void onResponse(Response response) {
            if (this.isDone.compareAndSet(false, true)) {
                this.cancellable.cancel();
                this.delegate.onResponse(response);
            }
        }

        @Override
        public void onFailure(Exception e) {
            if (this.isDone.compareAndSet(false, true)) {
                this.cancellable.cancel();
                this.delegate.onFailure(e);
            }
        }

        @Override
        public void run() {
            if (this.isDone.compareAndSet(false, true)) {
                String timeoutMessage = "[" + this.listenerName + "] timed out after [" + this.timeout + "]";
                this.delegate.onFailure(new ElasticsearchTimeoutException(timeoutMessage, new Object[0]));
            }
        }
    }
}

