/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.actions;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Persona;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionExecutor;
import org.apache.unomi.api.actions.ActionPostExecutor;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.ConfigSharingService;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.api.services.PrivacyService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeProfilesOnPropertyAction
implements ActionExecutor {
    private static final Logger logger = LoggerFactory.getLogger((String)MergeProfilesOnPropertyAction.class.getName());
    private ProfileService profileService;
    private PersistenceService persistenceService;
    private EventService eventService;
    private DefinitionsService definitionsService;
    private PrivacyService privacyService;
    private ConfigSharingService configSharingService;
    private int maxProfilesInOneMerge = -1;

    public int execute(Action action, final Event event) {
        String profileIdCookieName = (String)this.configSharingService.getProperty("profileIdCookieName");
        String profileIdCookieDomain = (String)this.configSharingService.getProperty("profileIdCookieDomain");
        Integer profileIdCookieMaxAgeInSeconds = (Integer)this.configSharingService.getProperty("profileIdCookieMaxAgeInSeconds");
        Boolean profileIdCookieHttpOnly = (Boolean)this.configSharingService.getProperty("profileIdCookieHttpOnly");
        Profile profile = event.getProfile();
        if (profile instanceof Persona || profile.isAnonymousProfile()) {
            return 0;
        }
        String mergeProfilePropertyName = (String)action.getParameterValues().get("mergeProfilePropertyName");
        if (StringUtils.isEmpty((CharSequence)mergeProfilePropertyName)) {
            return 0;
        }
        String mergeProfilePropertyValue = (String)action.getParameterValues().get("mergeProfilePropertyValue");
        if (StringUtils.isEmpty((CharSequence)mergeProfilePropertyValue)) {
            return 0;
        }
        String mergeProfilePreviousPropertyValue = profile.getSystemProperties().get(mergeProfilePropertyName) != null ? profile.getSystemProperties().get(mergeProfilePropertyName).toString() : "";
        final Session currentSession = event.getSession();
        boolean forceEventProfileAsMaster = action.getParameterValues().containsKey("forceEventProfileAsMaster") ? (Boolean)action.getParameterValues().get("forceEventProfileAsMaster") : false;
        final String profileId = profile.getItemId();
        Condition propertyCondition = new Condition(this.definitionsService.getConditionType("profilePropertyCondition"));
        propertyCondition.setParameter("comparisonOperator", (Object)"equals");
        propertyCondition.setParameter("propertyName", (Object)("systemProperties." + mergeProfilePropertyName));
        propertyCondition.setParameter("propertyValue", (Object)mergeProfilePropertyValue);
        Condition excludeMergedProfilesCondition = new Condition(this.definitionsService.getConditionType("profilePropertyCondition"));
        excludeMergedProfilesCondition.setParameter("comparisonOperator", (Object)"missing");
        excludeMergedProfilesCondition.setParameter("propertyName", (Object)"mergedWith");
        Condition c = new Condition(this.definitionsService.getConditionType("booleanCondition"));
        c.setParameter("operator", (Object)"and");
        c.setParameter("subConditions", Arrays.asList(propertyCondition, excludeMergedProfilesCondition));
        final List profiles = this.persistenceService.query(c, "properties.firstVisit", Profile.class, 0, this.maxProfilesInOneMerge).getList();
        if (StringUtils.isNotEmpty((CharSequence)mergeProfilePreviousPropertyValue) && !mergeProfilePreviousPropertyValue.equals(mergeProfilePropertyValue)) {
            if (profiles.size() > 0) {
                profile = (Profile)profiles.get(0);
            } else {
                if (forceEventProfileAsMaster) {
                    profile = event.getProfile();
                } else {
                    profile = new Profile(UUID.randomUUID().toString());
                    profile.setProperty("firstVisit", (Object)event.getTimeStamp());
                }
                profile.getSystemProperties().put(mergeProfilePropertyName, mergeProfilePropertyValue);
            }
            logger.info("Different users, switch to " + profile.getItemId());
            HttpServletResponse httpServletResponse = (HttpServletResponse)event.getAttributes().get("http_response");
            HttpServletRequest httpServletRequest = (HttpServletRequest)event.getAttributes().get("http_request");
            if (httpServletRequest != null) {
                MergeProfilesOnPropertyAction.sendProfileCookie(profile, (ServletResponse)httpServletResponse, profileIdCookieName, profileIdCookieDomain, profileIdCookieMaxAgeInSeconds, profileIdCookieHttpOnly, httpServletRequest.isSecure());
            }
            event.setProfileId(profile.getItemId());
            event.setProfile(profile);
            if (currentSession != null) {
                currentSession.setProfile(profile);
                this.eventService.send(new Event("sessionReassigned", currentSession, profile, event.getScope(), (Item)event, (Item)currentSession, null, event.getTimeStamp(), false));
            }
            return 6;
        }
        profile.getSystemProperties().put(mergeProfilePropertyName, mergeProfilePropertyValue);
        boolean add = true;
        for (Profile p : profiles) {
            add = add && !StringUtils.equals((CharSequence)p.getItemId(), (CharSequence)profile.getItemId());
        }
        if (add) {
            profiles.add(profile);
        }
        if (profiles.size() == 1) {
            return StringUtils.isEmpty((CharSequence)mergeProfilePreviousPropertyValue) ? 4 : 0;
        }
        Profile markedMasterProfile = forceEventProfileAsMaster ? event.getProfile() : (Profile)profiles.get(0);
        Profile masterProfile = this.profileService.mergeProfiles(markedMasterProfile, profiles);
        if (forceEventProfileAsMaster || !masterProfile.getItemId().equals(profileId)) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)event.getAttributes().get("http_response");
            HttpServletRequest httpServletRequest = (HttpServletRequest)event.getAttributes().get("http_request");
            if (httpServletRequest != null) {
                MergeProfilesOnPropertyAction.sendProfileCookie(profile, (ServletResponse)httpServletResponse, profileIdCookieName, profileIdCookieDomain, profileIdCookieMaxAgeInSeconds, profileIdCookieHttpOnly, httpServletRequest.isSecure());
            }
            final String masterProfileId = masterProfile.getItemId();
            event.setProfileId(masterProfileId);
            event.setProfile(masterProfile);
            final Boolean anonymousBrowsing = this.privacyService.isRequireAnonymousBrowsing(masterProfileId);
            if (currentSession != null) {
                currentSession.setProfile(masterProfile);
                if (this.privacyService.isRequireAnonymousBrowsing(profile).booleanValue()) {
                    this.privacyService.setRequireAnonymousBrowsing(masterProfileId, true, event.getScope());
                }
                if (anonymousBrowsing.booleanValue()) {
                    currentSession.setProfile(this.privacyService.getAnonymousProfile(masterProfile));
                    event.setProfileId(null);
                    this.persistenceService.save((Item)event);
                }
            }
            event.getActionPostExecutors().add(new ActionPostExecutor(){

                public boolean execute() {
                    try {
                        Event currentEvent = event;
                        if (!StringUtils.equals((CharSequence)profileId, (CharSequence)masterProfileId) && currentEvent.isPersistent()) {
                            MergeProfilesOnPropertyAction.this.persistenceService.update((Item)currentEvent, currentEvent.getTimeStamp(), Event.class, "profileId", (Object)(anonymousBrowsing != false ? null : masterProfileId));
                        }
                        for (Profile profile : profiles) {
                            boolean isExist;
                            Object session2;
                            String profileId2 = profile.getItemId();
                            if (StringUtils.equals((CharSequence)profileId2, (CharSequence)masterProfileId)) continue;
                            List sessions = MergeProfilesOnPropertyAction.this.persistenceService.query("profileId", profileId2, null, Session.class);
                            if (currentSession != null && masterProfileId.equals(profileId2) && !sessions.contains(currentSession)) {
                                sessions.add(currentSession);
                            }
                            for (Object session2 : sessions) {
                                MergeProfilesOnPropertyAction.this.persistenceService.update((Item)session2, session2.getTimeStamp(), Session.class, "profileId", (Object)(anonymousBrowsing != false ? null : masterProfileId));
                            }
                            List events = MergeProfilesOnPropertyAction.this.persistenceService.query("profileId", profileId2, null, Event.class);
                            session2 = events.iterator();
                            while (session2.hasNext()) {
                                Event event2 = (Event)session2.next();
                                if (event2.getItemId().equals(currentEvent.getItemId())) continue;
                                MergeProfilesOnPropertyAction.this.persistenceService.update((Item)event2, event2.getTimeStamp(), Event.class, "profileId", (Object)(anonymousBrowsing != false ? null : masterProfileId));
                            }
                            profile.setMergedWith(masterProfileId);
                            HashMap<String, Object> sourceMap = new HashMap<String, Object>();
                            sourceMap.put("mergedWith", masterProfileId);
                            profile.setSystemProperty("lastUpdated", (Object)new Date());
                            sourceMap.put("systemProperties", profile.getSystemProperties());
                            boolean bl = isExist = MergeProfilesOnPropertyAction.this.persistenceService.load(profile.getItemId(), Profile.class) != null;
                            if (!isExist) {
                                MergeProfilesOnPropertyAction.this.persistenceService.save((Item)profile);
                                continue;
                            }
                            MergeProfilesOnPropertyAction.this.persistenceService.update((Item)profile, null, Profile.class, sourceMap, true);
                        }
                    }
                    catch (Exception e) {
                        logger.error("unable to execute callback action, profile and session will not be saved", (Throwable)e);
                        return false;
                    }
                    return true;
                }
            });
            return 6;
        }
        return StringUtils.isEmpty((CharSequence)mergeProfilePreviousPropertyValue) ? 4 : 0;
    }

    private static void sendProfileCookie(Profile profile, ServletResponse response, String profileIdCookieName, String profileIdCookieDomain, int cookieAgeInSeconds, boolean httpOnly, boolean secure) {
        if (response != null && response instanceof HttpServletResponse) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            if (!(profile instanceof Persona)) {
                httpServletResponse.addHeader("Set-Cookie", profileIdCookieName + "=" + profile.getItemId() + "; Path=/; Max-Age=" + cookieAgeInSeconds + (StringUtils.isNotBlank((CharSequence)profileIdCookieDomain) ? "; Domain=" + profileIdCookieDomain : "") + "; SameSite=Lax" + (secure ? "; Secure" : "") + (httpOnly ? "; HttpOnly" : ""));
            }
        }
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public void setPrivacyService(PrivacyService privacyService) {
        this.privacyService = privacyService;
    }

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    public void setConfigSharingService(ConfigSharingService configSharingService) {
        this.configSharingService = configSharingService;
    }

    public void setMaxProfilesInOneMerge(String maxProfilesInOneMerge) {
        this.maxProfilesInOneMerge = Integer.parseInt(maxProfilesInOneMerge);
    }
}

