/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.build;

import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.bnd.osgi.Processor;
import aQute.lib.exceptions.Exceptions;
import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;

public class Run
extends Project {
    private static final MethodHandle createBndrun;

    public static Run createRun(Workspace workspace, File file) throws Exception {
        if (createBndrun == null) {
            return Run.createRun0(workspace, file);
        }
        try {
            return createBndrun.invoke(workspace, file);
        }
        catch (Throwable e) {
            throw Exceptions.duck(e);
        }
    }

    private static Run createRun0(Workspace workspace, File file) throws Exception {
        Processor processor;
        if (workspace != null) {
            Run run = new Run(workspace, file);
            if (run.getProperties().get("-standalone") == null) {
                return run;
            }
            processor = run;
        } else {
            processor = new Processor();
            processor.setProperties(file);
        }
        Workspace standaloneWorkspace = Workspace.createStandaloneWorkspace(processor, file.toURI());
        Run run = new Run(standaloneWorkspace, file);
        return run;
    }

    public Run(Workspace workspace, File projectDir, File propertiesFile) throws Exception {
        super(workspace, projectDir, propertiesFile);
    }

    public Run(Workspace workspace, File propertiesFile) throws Exception {
        super(workspace, propertiesFile == null ? null : propertiesFile.getParentFile(), propertiesFile);
    }

    @Override
    public void report(Map<String, Object> table) throws Exception {
        super.report(table, false);
    }

    @Override
    public String getName() {
        return this.getPropertiesFile().getName();
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        MethodHandle handle = null;
        try {
            Class<?> clazz = Run.class.getClassLoader().loadClass("biz.aQute.resolve.Bndrun");
            MethodType type = MethodType.methodType(clazz, Workspace.class, File.class);
            handle = lookup.findStatic(clazz, "createBndrun", type);
        }
        catch (Throwable e) {
            handle = null;
        }
        createBndrun = handle;
    }
}

