/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.groovy.actions.services.impl;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import groovy.util.GroovyScriptEngine;
import groovy.util.ResourceConnector;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.Parameter;
import org.apache.unomi.api.actions.ActionType;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.SchedulerService;
import org.apache.unomi.groovy.actions.GroovyAction;
import org.apache.unomi.groovy.actions.GroovyBundleResourceConnector;
import org.apache.unomi.groovy.actions.annotations.Action;
import org.apache.unomi.groovy.actions.services.GroovyActionsService;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.services.actions.ActionExecutorDispatcher;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyActionsServiceImpl
implements GroovyActionsService {
    private BundleContext bundleContext;
    private GroovyScriptEngine groovyScriptEngine;
    private GroovyShell groovyShell;
    private Map<String, GroovyCodeSource> groovyCodeSourceMap;
    private ScheduledFuture<?> scheduledFuture;
    private static final Logger logger = LoggerFactory.getLogger((String)GroovyActionsServiceImpl.class.getName());
    private static final String BASE_SCRIPT_NAME = "BaseScript";
    @Reference
    private DefinitionsService definitionsService;
    @Reference
    private PersistenceService persistenceService;
    @Reference
    private SchedulerService schedulerService;
    @Reference
    private ActionExecutorDispatcher actionExecutorDispatcher;
    private Integer groovyActionsRefreshInterval = 1000;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setGroovyActionsRefreshInterval(Integer groovyActionsRefreshInterval) {
        this.groovyActionsRefreshInterval = groovyActionsRefreshInterval;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public void setActionExecutorDispatcher(ActionExecutorDispatcher actionExecutorDispatcher) {
        this.actionExecutorDispatcher = actionExecutorDispatcher;
    }

    @Override
    public GroovyShell getGroovyShell() {
        return this.groovyShell;
    }

    public void postConstruct() {
        logger.debug("postConstruct {}", (Object)this.bundleContext.getBundle());
        this.groovyCodeSourceMap = new HashMap<String, GroovyCodeSource>();
        GroovyBundleResourceConnector bundleResourceConnector = new GroovyBundleResourceConnector(this.bundleContext);
        GroovyClassLoader groovyLoader = new GroovyClassLoader(((BundleWiring)this.bundleContext.getBundle().adapt(BundleWiring.class)).getClassLoader());
        this.groovyScriptEngine = new GroovyScriptEngine((ResourceConnector)bundleResourceConnector, (ClassLoader)groovyLoader);
        this.initializeGroovyShell();
        try {
            this.loadBaseScript();
        }
        catch (IOException e) {
            logger.error("Failed to load base script", (Throwable)e);
        }
        this.initializeTimers();
        logger.info("Groovy action service initialized.");
    }

    public void onDestroy() {
        logger.debug("onDestroy Method called");
        this.scheduledFuture.cancel(true);
    }

    private void loadBaseScript() throws IOException {
        URL groovyBaseScriptURL = this.bundleContext.getBundle().getEntry("META-INF/base/BaseScript.groovy");
        if (groovyBaseScriptURL == null) {
            return;
        }
        logger.debug("Found Groovy base script at {}, loading... ", (Object)groovyBaseScriptURL.getPath());
        GroovyCodeSource groovyCodeSource = new GroovyCodeSource(IOUtils.toString((InputStream)groovyBaseScriptURL.openStream()), BASE_SCRIPT_NAME, "/groovy/script");
        this.groovyCodeSourceMap.put(BASE_SCRIPT_NAME, groovyCodeSource);
        this.groovyScriptEngine.getGroovyClassLoader().parseClass(groovyCodeSource, true);
    }

    private void initializeGroovyShell() {
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.addCompilationCustomizers(new CompilationCustomizer[]{this.createImportCustomizer()});
        compilerConfiguration.setScriptBaseClass(BASE_SCRIPT_NAME);
        this.groovyScriptEngine.setConfig(compilerConfiguration);
        this.groovyShell = new GroovyShell((ClassLoader)this.groovyScriptEngine.getGroovyClassLoader(), compilerConfiguration);
        this.groovyShell.setVariable("actionExecutorDispatcher", (Object)this.actionExecutorDispatcher);
        this.groovyShell.setVariable("definitionsService", (Object)this.definitionsService);
        this.groovyShell.setVariable("logger", (Object)LoggerFactory.getLogger((String)"GroovyAction"));
    }

    private ImportCustomizer createImportCustomizer() {
        ImportCustomizer importCustomizer = new ImportCustomizer();
        importCustomizer.addImports(new String[]{"org.apache.unomi.api.services.EventService", "org.apache.unomi.groovy.actions.annotations.Action", "org.apache.unomi.groovy.actions.annotations.Parameter"});
        return importCustomizer;
    }

    @Override
    public void save(String actionName, String groovyScript) {
        this.handleFile(actionName, groovyScript);
    }

    private void handleFile(String actionName, String groovyScript) {
        GroovyCodeSource groovyCodeSource = this.buildClassScript(groovyScript, actionName);
        try {
            this.saveActionType(this.groovyShell.parse(groovyCodeSource).getClass().getMethod("execute", new Class[0]).getAnnotation(Action.class));
            this.saveScript(actionName, groovyScript);
            this.groovyCodeSourceMap.put(actionName, groovyCodeSource);
            logger.info("The script {} has been loaded.", (Object)actionName);
        }
        catch (NoSuchMethodException e) {
            logger.error("Failed to save the script {}", (Object)actionName, (Object)e);
        }
    }

    private void saveActionType(Action action) {
        Metadata metadata = new Metadata(null, action.id(), action.name().equals("") ? action.id() : action.name(), action.description());
        metadata.setHidden(action.hidden());
        metadata.setReadOnly(true);
        metadata.setSystemTags(new HashSet<String>(Arrays.asList(action.systemTags())));
        ActionType actionType = new ActionType(metadata);
        actionType.setActionExecutor(action.actionExecutor());
        actionType.setParameters(Stream.of(action.parameters()).map(parameter -> new Parameter(parameter.id(), parameter.type(), parameter.multivalued())).collect(Collectors.toList()));
        this.definitionsService.setActionType(actionType);
    }

    @Override
    public void remove(String id) {
        try {
            this.definitionsService.removeActionType(this.groovyShell.parse(this.groovyCodeSourceMap.get(id)).getClass().getMethod("execute", new Class[0]).getAnnotation(Action.class).id());
        }
        catch (NoSuchMethodException e) {
            logger.error("Failed to delete the action type for the id {}", (Object)id, (Object)e);
        }
        this.persistenceService.remove(id, GroovyAction.class);
        this.groovyCodeSourceMap.remove(id);
    }

    @Override
    public GroovyCodeSource getGroovyCodeSource(String id) {
        return this.groovyCodeSourceMap.get(id);
    }

    private GroovyCodeSource buildClassScript(String groovyScript, String actionName) {
        return new GroovyCodeSource(groovyScript, actionName, "/groovy/script");
    }

    private void saveScript(String name, String script) {
        GroovyAction groovyScript = new GroovyAction(name, script);
        this.persistenceService.save((Item)groovyScript);
    }

    private void refreshGroovyActions() {
        GroovyCodeSource baseScript = this.groovyCodeSourceMap.get(BASE_SCRIPT_NAME);
        this.groovyCodeSourceMap = new HashMap<String, GroovyCodeSource>();
        this.groovyCodeSourceMap.put(BASE_SCRIPT_NAME, baseScript);
        this.persistenceService.getAllItems(GroovyAction.class).forEach(groovyAction -> this.groovyCodeSourceMap.put(groovyAction.getName(), this.buildClassScript(groovyAction.getScript(), groovyAction.getName())));
    }

    private void initializeTimers() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                GroovyActionsServiceImpl.this.refreshGroovyActions();
            }
        };
        this.scheduledFuture = this.schedulerService.getScheduleExecutorService().scheduleWithFixedDelay(task, 0L, this.groovyActionsRefreshInterval.intValue(), TimeUnit.MILLISECONDS);
    }
}

