/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.service.impl;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.apache.unomi.api.PluginType;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={ResourceBundleHelper.class})
public class ResourceBundleHelper {
    private static final Pattern COMMA = Pattern.compile(",", 16);
    private static final String RESOURCE_BUNDLE = "messages";
    private BundleContext bundleContext;

    @Activate
    public void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
    }

    private ResourceBundle getBundle(String lang, Bundle bundle, ClassLoader loader) {
        Locale locale = this.getLocale(lang);
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale, loader);
            if (resourceBundle != null && locale.equals(resourceBundle.getLocale())) {
                return resourceBundle;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (locale.getCountry().length() > 0) {
            return this.getBundle(locale.getLanguage(), bundle, loader);
        }
        return null;
    }

    private Locale getLocale(String lang) {
        int i = lang.indexOf(59);
        if (i > -1) {
            lang = lang.substring(0, i);
        }
        return Locale.forLanguageTag(lang);
    }

    public ResourceBundle getResourceBundle(PluginType object, String language) {
        ResourceBundle resourceBundle = null;
        Bundle bundle = this.bundleContext.getBundle(object.getPluginId());
        ClassLoader loader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
        if (language != null) {
            if (language.indexOf(44) != -1) {
                String lang;
                String[] langs;
                String[] stringArray = langs = COMMA.split(language);
                int n = stringArray.length;
                for (int i = 0; i < n && (resourceBundle = this.getBundle(lang = stringArray[i], bundle, loader)) == null; ++i) {
                }
            } else {
                resourceBundle = this.getBundle(language, bundle, loader);
            }
        }
        if (resourceBundle == null) {
            try {
                return ResourceBundle.getBundle(RESOURCE_BUNDLE, Locale.ENGLISH, loader);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return resourceBundle;
    }

    public String getResourceBundleValue(ResourceBundle bundle, String nameKey) {
        try {
            if (bundle != null) {
                return bundle.getString(nameKey);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return "???" + nameKey + "???";
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

