/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;

public class RestNodesInfoAction
extends BaseRestHandler {
    static final Set<String> ALLOWED_METRICS = Sets.newHashSet("http", "ingest", "indices", "jvm", "os", "plugins", "process", "settings", "thread_pool", "transport");
    private final SettingsFilter settingsFilter;

    public RestNodesInfoAction(RestController controller, SettingsFilter settingsFilter) {
        controller.registerHandler(RestRequest.Method.GET, "/_nodes", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/{metrics}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_nodes/{nodeId}/info/{metrics}", this);
        this.settingsFilter = settingsFilter;
    }

    @Override
    public String getName() {
        return "nodes_info_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        NodesInfoRequest nodesInfoRequest = RestNodesInfoAction.prepareRequest(request);
        this.settingsFilter.addFilterSettingParams(request);
        return channel -> client.admin().cluster().nodesInfo(nodesInfoRequest, new RestActions.NodesResponseRestListener<NodesInfoResponse>((RestChannel)channel));
    }

    static NodesInfoRequest prepareRequest(RestRequest request) {
        Set<String> metrics;
        String[] nodeIds;
        if (request.hasParam("nodeId") && !request.hasParam("metrics")) {
            String nodeId = request.param("nodeId", "_all");
            Set<String> metricsOrNodeIds = Strings.tokenizeByCommaToSet(nodeId);
            boolean isMetricsOnly = ALLOWED_METRICS.containsAll(metricsOrNodeIds);
            if (isMetricsOnly) {
                nodeIds = new String[]{"_all"};
                metrics = metricsOrNodeIds;
            } else {
                nodeIds = Strings.tokenizeToStringArray(nodeId, ",");
                metrics = Sets.newHashSet("_all");
            }
        } else {
            nodeIds = Strings.tokenizeToStringArray(request.param("nodeId", "_all"), ",");
            metrics = Strings.tokenizeByCommaToSet(request.param("metrics", "_all"));
        }
        NodesInfoRequest nodesInfoRequest = new NodesInfoRequest(nodeIds);
        nodesInfoRequest.timeout(request.param("timeout"));
        if (metrics.size() == 1 && metrics.contains("_all")) {
            nodesInfoRequest.all();
        } else {
            nodesInfoRequest.clear();
            nodesInfoRequest.settings(metrics.contains("settings"));
            nodesInfoRequest.os(metrics.contains("os"));
            nodesInfoRequest.process(metrics.contains("process"));
            nodesInfoRequest.jvm(metrics.contains("jvm"));
            nodesInfoRequest.threadPool(metrics.contains("thread_pool"));
            nodesInfoRequest.transport(metrics.contains("transport"));
            nodesInfoRequest.http(metrics.contains("http"));
            nodesInfoRequest.plugins(metrics.contains("plugins"));
            nodesInfoRequest.ingest(metrics.contains("ingest"));
            nodesInfoRequest.indices(metrics.contains("indices"));
        }
        return nodesInfoRequest;
    }

    @Override
    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }
}

