/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.collections;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class Iterables {
    private Iterables() {
    }

    public static <T> Iterable<T> distinct(Set<? extends T> first, Iterable<? extends T> second) {
        return new Distinct<Object, Object>(first, second, t -> t, t -> true);
    }

    public static <T, R> Iterable<R> distinct(Set<? extends T> first, Iterable<? extends T> second, Function<? super T, ? extends R> mapper) {
        return new Distinct<T, Object>(first, second, mapper, r -> true);
    }

    public static <T, R> Iterable<R> distinct(Set<? extends T> first, Iterable<? extends T> second, Function<? super T, ? extends R> mapper, Predicate<? super R> filter) {
        return new Distinct<T, R>(first, second, mapper, filter);
    }

    public static <T> Iterable<T> iterable(Enumeration<? extends T> enumeration) {
        return new IterableEnumeration<Object, Object>(enumeration, t -> t, t -> true);
    }

    public static <T, R> Iterable<R> iterable(Enumeration<? extends T> enumeration, Function<? super T, ? extends R> mapper) {
        return new IterableEnumeration<T, Object>(enumeration, mapper, r -> true);
    }

    public static <T, R> Iterable<R> iterable(Enumeration<? extends T> enumeration, Function<? super T, ? extends R> mapper, Predicate<? super R> filter) {
        return new IterableEnumeration<T, R>(enumeration, mapper, filter);
    }

    private static class Distinct<T, R>
    implements Iterable<R> {
        private final Set<? extends T> first;
        private final Iterable<? extends T> second;
        private final Function<? super T, ? extends R> mapper;
        private final Predicate<? super R> filter;

        Distinct(Set<? extends T> first, Iterable<? extends T> second, Function<? super T, ? extends R> mapper, Predicate<? super R> filter) {
            this.first = Objects.requireNonNull(first);
            this.second = Objects.requireNonNull(second);
            this.mapper = Objects.requireNonNull(mapper);
            this.filter = Objects.requireNonNull(filter);
        }

        @Override
        public void forEach(Consumer<? super R> action) {
            Objects.requireNonNull(action);
            Iterator<T> it1 = this.first.iterator();
            Iterator<T> it2 = this.second.iterator();
            it1.forEachRemaining(t -> {
                R r = this.mapper.apply(t);
                if (this.filter.test(r)) {
                    action.accept((R)r);
                }
            });
            it2.forEachRemaining(t -> {
                R r = this.mapper.apply(t);
                if (this.filter.test(r) && !this.first.contains(t)) {
                    action.accept((R)r);
                }
            });
        }

        @Override
        public Iterator<R> iterator() {
            return new Iterator<R>(){
                private final Iterator<? extends T> it1;
                private final Iterator<? extends T> it2;
                private boolean hasNext;
                private R next;
                {
                    this.it1 = distinct.first.iterator();
                    this.it2 = distinct.second.iterator();
                    this.hasNext = false;
                }

                /*
                 * Unable to fully structure code
                 */
                @Override
                public boolean hasNext() {
                    if (!this.hasNext) ** GOTO lbl9
                    return true;
lbl-1000:
                    // 1 sources

                    {
                        t = this.it1.next();
                        r = Distinct.access$2(this).apply(t);
                        if (!Distinct.access$3(this).test(r)) continue;
                        this.next = r;
                        this.hasNext = true;
                        return true;
lbl9:
                        // 2 sources

                        ** while (this.it1.hasNext())
                    }
lbl10:
                    // 2 sources

                    while (this.it2.hasNext()) {
                        t = this.it2.next();
                        r = Distinct.access$2(this).apply(t);
                        if (!Distinct.access$3(this).test(r) || Distinct.access$0(this).contains(t)) continue;
                        this.next = r;
                        this.hasNext = true;
                        return true;
                    }
                    return false;
                }

                @Override
                public R next() {
                    if (this.hasNext()) {
                        this.hasNext = false;
                        return this.next;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public Spliterator<R> spliterator() {
            final Spliterator<T> it1 = this.first.spliterator();
            final Spliterator<T> it2 = this.second.spliterator();
            long est = it1.estimateSize() + it2.estimateSize();
            int characteristics = 1;
            if (est < 0L) {
                est = Long.MAX_VALUE;
            } else {
                characteristics |= 0x40;
            }
            if (it1.hasCharacteristics(16)) {
                characteristics |= 0x10;
            }
            return new Spliterators.AbstractSpliterator<R>(est, characteristics){

                @Override
                public boolean tryAdvance(Consumer<? super R> action) {
                    Objects.requireNonNull(action);
                    if (it1.tryAdvance((? super T t) -> {
                        Object r = mapper.apply(t);
                        if (filter.test(r)) {
                            action.accept((Object)r);
                        }
                    })) {
                        return true;
                    }
                    return it2.tryAdvance((? super T t) -> {
                        Object r = mapper.apply(t);
                        if (filter.test(r) && !first.contains(t)) {
                            action.accept((Object)r);
                        }
                    });
                }
            };
        }
    }

    private static class IterableEnumeration<T, R>
    implements Iterable<R> {
        private final Enumeration<? extends T> enumeration;
        private final Function<? super T, ? extends R> mapper;
        private final Predicate<? super R> filter;
        private final AtomicBoolean consume = new AtomicBoolean();

        IterableEnumeration(Enumeration<? extends T> enumeration, Function<? super T, ? extends R> mapper, Predicate<? super R> filter) {
            this.enumeration = enumeration != null ? enumeration : Collections.emptyEnumeration();
            this.mapper = Objects.requireNonNull(mapper);
            this.filter = Objects.requireNonNull(filter);
        }

        private void consume() {
            if (this.consume.compareAndSet(false, true)) {
                return;
            }
            throw new IllegalStateException("enumeration already consumed");
        }

        @Override
        public void forEach(Consumer<? super R> action) {
            Objects.requireNonNull(action);
            this.consume();
            while (this.enumeration.hasMoreElements()) {
                T t = this.enumeration.nextElement();
                R r = this.mapper.apply(t);
                if (!this.filter.test(r)) continue;
                action.accept(r);
            }
        }

        @Override
        public Iterator<R> iterator() {
            this.consume();
            return new Iterator<R>(){
                private boolean hasNext = false;
                private R next;

                /*
                 * Unable to fully structure code
                 */
                @Override
                public boolean hasNext() {
                    if (!this.hasNext) ** GOTO lbl9
                    return true;
lbl-1000:
                    // 1 sources

                    {
                        t = IterableEnumeration.access$0(this).nextElement();
                        r = IterableEnumeration.access$1(this).apply(t);
                        if (!IterableEnumeration.access$2(this).test(r)) continue;
                        this.next = r;
                        this.hasNext = true;
                        return true;
lbl9:
                        // 2 sources

                        ** while (IterableEnumeration.access$0((IterableEnumeration)this).hasMoreElements())
                    }
lbl10:
                    // 1 sources

                    return false;
                }

                @Override
                public R next() {
                    if (this.hasNext()) {
                        this.hasNext = false;
                        return this.next;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public Spliterator<R> spliterator() {
            this.consume();
            return new Spliterators.AbstractSpliterator<R>(Long.MAX_VALUE, 16){

                @Override
                public boolean tryAdvance(Consumer<? super R> action) {
                    Objects.requireNonNull(action);
                    if (enumeration.hasMoreElements()) {
                        Object t = enumeration.nextElement();
                        Object r = mapper.apply(t);
                        if (filter.test(r)) {
                            action.accept(r);
                        }
                        return true;
                    }
                    return false;
                }
            };
        }
    }
}

