/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.jsp;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.TaglibDescriptor;
import org.apache.catalina.loader.WebappClassLoader;
import org.apache.jasper.compiler.Localizer;
import org.apache.tomcat.util.descriptor.tld.TaglibXml;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;
import org.ops4j.pax.web.jsp.TldParser;
import org.ops4j.pax.web.service.spi.util.ResourceDelegatingBundleClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class TldScanner {
    private static final Logger LOG = LoggerFactory.getLogger(TldScanner.class);
    private static final String MSG = "org.apache.jasper.servlet.TldScanner";
    private static final String TLD_EXT = ".tld";
    private static final String WEB_INF = "/WEB-INF/";
    private final ServletContext context;
    private final TldParser tldParser;
    private final Map<String, TldResourcePath> uriTldResourcePathMap = new HashMap<String, TldResourcePath>();
    private final Map<TldResourcePath, TaglibXml> tldResourcePathTaglibXmlMap = new HashMap<TldResourcePath, TaglibXml>();
    private final List<String> listeners = new ArrayList<String>();

    public TldScanner(ServletContext context, boolean namespaceAware, boolean validation, boolean blockExternal) {
        this.context = context;
        this.tldParser = new TldParser(namespaceAware, validation, blockExternal);
    }

    public void scan() throws IOException, SAXException {
        this.scanPlatform();
        this.scanJspConfig();
        this.scanResourcePaths(WEB_INF);
        this.scanJars();
    }

    public Map<String, TldResourcePath> getUriTldResourcePathMap() {
        return this.uriTldResourcePathMap;
    }

    public Map<TldResourcePath, TaglibXml> getTldResourcePathTaglibXmlMap() {
        return this.tldResourcePathTaglibXmlMap;
    }

    public List<String> getListeners() {
        return this.listeners;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.tldParser.setClassLoader(classLoader);
    }

    protected void scanPlatform() {
    }

    protected void scanJspConfig() throws IOException, SAXException {
        JspConfigDescriptor jspConfigDescriptor = this.context.getJspConfigDescriptor();
        if (jspConfigDescriptor == null) {
            return;
        }
        Collection descriptors = jspConfigDescriptor.getTaglibs();
        for (TaglibDescriptor descriptor : descriptors) {
            URL url;
            if (descriptor == null) continue;
            String taglibURI = descriptor.getTaglibURI();
            String resourcePath = descriptor.getTaglibLocation();
            if (!resourcePath.startsWith("/")) {
                resourcePath = WEB_INF + resourcePath;
            }
            if (this.uriTldResourcePathMap.containsKey(taglibURI)) {
                LOG.warn(Localizer.getMessage("org.apache.jasper.servlet.TldScanner.webxmlSkip", resourcePath, taglibURI));
                continue;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(Localizer.getMessage("org.apache.jasper.servlet.TldScanner.webxmlAdd", resourcePath, taglibURI));
            }
            if ((url = this.context.getResource(resourcePath)) != null) {
                TldResourcePath tldResourcePath = resourcePath.endsWith(".jar") ? new TldResourcePath(url, resourcePath, "META-INF/taglib.tld") : new TldResourcePath(url, resourcePath);
                TaglibXml tld = this.tldParser.parse(tldResourcePath);
                this.uriTldResourcePathMap.put(taglibURI, tldResourcePath);
                this.tldResourcePathTaglibXmlMap.put(tldResourcePath, tld);
                if (tld.getListeners() == null) continue;
                this.listeners.addAll(tld.getListeners());
                continue;
            }
            LOG.warn(Localizer.getMessage("org.apache.jasper.servlet.TldScanner.webxmlFailPathDoesNotExist", resourcePath, taglibURI));
        }
    }

    protected void scanResourcePaths(String startPath) throws IOException, SAXException {
        Set dirList = this.context.getResourcePaths(startPath);
        if (dirList != null) {
            for (String path : dirList) {
                if (path.startsWith("/WEB-INF/classes/") || path.startsWith("/WEB-INF/lib/")) continue;
                if (path.endsWith("/")) {
                    this.scanResourcePaths(path);
                    continue;
                }
                if (path.startsWith("/WEB-INF/tags/")) {
                    if (!path.endsWith("/implicit.tld")) continue;
                    this.parseTld(path);
                    continue;
                }
                if (!path.endsWith(TLD_EXT)) continue;
                this.parseTld(path);
            }
        }
    }

    public void scanJars() throws IOException {
        ClassLoader parent;
        ClassLoader webappLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader parentLoader = webappLoader.getParent();
        ResourceDelegatingBundleClassLoader classLoader = null;
        if (webappLoader instanceof ResourceDelegatingBundleClassLoader) {
            classLoader = (ResourceDelegatingBundleClassLoader)webappLoader;
        } else if (parentLoader instanceof ResourceDelegatingBundleClassLoader) {
            classLoader = (ResourceDelegatingBundleClassLoader)parentLoader;
        } else if (this.isTomcatWebLoader() && (parent = ((WebappClassLoader)webappLoader).getParent()) instanceof ResourceDelegatingBundleClassLoader) {
            classLoader = (ResourceDelegatingBundleClassLoader)parent;
        }
        List bundles = classLoader == null ? Collections.emptyList() : classLoader.getBundles();
        for (Bundle bundle : bundles) {
            Collection<Enumeration<Enumeration>> enumerations;
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            if (bundleWiring == null) {
                Enumeration urls = bundle.findEntries("META-INF", "*.tld", true);
                enumerations = Collections.singleton(urls);
            } else {
                Collection resources = bundleWiring.listResources("META-INF", "*.tld", 1);
                enumerations = new ArrayList(resources.size());
                for (String resource : resources) {
                    Enumeration urls = bundle.getResources(resource);
                    enumerations.add(urls);
                }
            }
            for (Enumeration enumeration : enumerations) {
                if (enumeration == null) continue;
                while (enumeration.hasMoreElements()) {
                    URL url = (URL)enumeration.nextElement();
                    LOG.info("found TLD {}", (Object)url);
                    TldResourcePath tldResourcePath = new TldResourcePath(url, null, null);
                    try {
                        this.parseTld(tldResourcePath);
                    }
                    catch (SAXException e) {
                        throw new IOException(e);
                    }
                }
            }
        }
    }

    private boolean isTomcatWebLoader() {
        try {
            return WebappClassLoader.class != null;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    protected void parseTld(String resourcePath) throws IOException, SAXException {
        TldResourcePath tldResourcePath = new TldResourcePath(this.context.getResource(resourcePath), resourcePath);
        this.parseTld(tldResourcePath);
    }

    protected void parseTld(TldResourcePath path) throws IOException, SAXException {
        if (this.tldResourcePathTaglibXmlMap.containsKey(path)) {
            return;
        }
        TaglibXml tld = this.tldParser.parse(path);
        String uri = tld.getUri();
        if (uri != null && !this.uriTldResourcePathMap.containsKey(uri)) {
            this.uriTldResourcePathMap.put(uri, path);
        }
        this.tldResourcePathTaglibXmlMap.put(path, tld);
        if (tld.getListeners() != null) {
            this.listeners.addAll(tld.getListeners());
        }
    }
}

