/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.uniffle.client.RestClient;
import org.apache.uniffle.client.exception.UniffleRestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClientImpl
implements RestClient {
    private static final Logger LOG = LoggerFactory.getLogger(RestClientImpl.class);
    private CloseableHttpClient httpclient;
    private String baseUrl;
    private final ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public RestClientImpl(String baseUrl, CloseableHttpClient httpclient) {
        this.httpclient = httpclient;
        this.baseUrl = baseUrl;
    }

    @Override
    public void close() throws Exception {
        if (this.httpclient != null) {
            this.httpclient.close();
        }
    }

    @Override
    public String get(String path, Map<String, Object> params, String authHeader) {
        return this.doRequest(this.buildURI(path, params), authHeader, RequestBuilder.get());
    }

    @Override
    public String post(String path, Map<String, Object> params, String authHeader) {
        RequestBuilder post = RequestBuilder.post();
        String requestBody = "";
        try {
            requestBody = this.mapper.writeValueAsString(params);
            StringEntity requestEntity = new StringEntity(requestBody);
            post.setEntity((HttpEntity)requestEntity);
        }
        catch (JsonProcessingException e) {
            LOG.error("params{} to json error.", params, (Object)e);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("params{} to StringEntity error.", params, (Object)e);
        }
        return this.doRequest(this.buildURI(path, null), authHeader, post);
    }

    private String doRequest(URI uri, String authHeader, RequestBuilder requestBuilder) {
        String response;
        try {
            if (requestBuilder.getFirstHeader("Content-Type") == null) {
                requestBuilder.setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
            }
            if (StringUtils.isNotBlank((CharSequence)authHeader)) {
                requestBuilder.setHeader("Authorization", authHeader);
            }
            HttpUriRequest httpRequest = requestBuilder.setUri(uri).build();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing {} request: {}", (Object)httpRequest.getMethod(), (Object)uri);
            }
            ResponseHandler responseHandler = resp -> {
                String entityStr;
                int status = resp.getStatusLine().getStatusCode();
                HttpEntity entity = resp.getEntity();
                String string = entityStr = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                if (status >= 200 && status < 300) {
                    return entityStr;
                }
                throw new HttpResponseException(status, entityStr);
            };
            response = (String)this.httpclient.execute(httpRequest, responseHandler);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response: {}", (Object)response);
            }
        }
        catch (ConnectException | NoHttpResponseException | ConnectTimeoutException e) {
            throw new UniffleRestException("Api request failed for " + uri.toString(), e);
        }
        catch (UniffleRestException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            LOG.error("Error: ", (Throwable)e);
            throw new UniffleRestException("Api request failed for " + uri.toString(), e);
        }
        return response;
    }

    private URI buildURI(String path, Map<String, Object> params) {
        URI uri;
        try {
            String url = StringUtils.isNotBlank((CharSequence)path) ? this.baseUrl + "/" + path : this.baseUrl;
            URIBuilder builder = new URIBuilder(url);
            if (params != null && !params.isEmpty()) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    if (entry.getValue() == null) continue;
                    builder.addParameter(entry.getKey(), entry.getValue().toString());
                }
            }
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new UniffleRestException("invalid URI.", e);
        }
        return uri;
    }
}

