/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.cli;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.uniffle.AbstractCustomCommandLine;
import org.apache.uniffle.UniffleCliArgsException;
import org.apache.uniffle.api.AdminRestApi;
import org.apache.uniffle.client.UniffleRestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniffleAdminCLI
extends AbstractCustomCommandLine {
    private static final Logger LOG = LoggerFactory.getLogger(UniffleAdminCLI.class);
    private final Options allOptions = new Options();
    private final Option refreshCheckerCli;
    private final Option help;

    public UniffleAdminCLI(String shortPrefix, String longPrefix) {
        this.refreshCheckerCli = new Option(shortPrefix + "r", longPrefix + "refreshChecker", false, "This is an admin command that will refresh access checker.");
        this.help = new Option(shortPrefix + "h", longPrefix + "help", false, "Help for the Uniffle Admin CLI.");
        this.allOptions.addOption(this.refreshCheckerCli);
        this.allOptions.addOption(this.help);
    }

    public UniffleAdminCLI(String shortPrefix, String longPrefix, UniffleRestClient client) {
        this(shortPrefix, longPrefix);
        this.client = client;
    }

    public int run(String[] args) throws UniffleCliArgsException {
        CommandLine cmd = this.parseCommandLineOptions(args, true);
        if (args != null && args.length < 1) {
            this.printUsage();
            return 1;
        }
        if (cmd.hasOption(this.help.getOpt())) {
            this.printUsage();
            return 0;
        }
        if (cmd.hasOption(this.coordinatorHost.getOpt()) && cmd.hasOption(this.coordinatorPort.getOpt())) {
            this.getUniffleRestClient(cmd);
        }
        if (cmd.hasOption(this.refreshCheckerCli.getOpt())) {
            LOG.info("uniffle-admin-cli : refresh coordinator access checker!");
            this.refreshAccessChecker();
            return 0;
        }
        return 1;
    }

    private String refreshAccessChecker() throws UniffleCliArgsException {
        if (this.client == null) {
            throw new UniffleCliArgsException("Missing Coordinator host address and grpc port parameters.");
        }
        AdminRestApi adminRestApi = new AdminRestApi(this.client);
        return adminRestApi.refreshAccessChecker();
    }

    @Override
    public void addRunOptions(Options baseOptions) {
        for (Object option : this.allOptions.getOptions()) {
            baseOptions.addOption((Option)option);
        }
    }

    @Override
    public void addGeneralOptions(Options baseOptions) {
        baseOptions.addOption(this.help);
    }

    public static void main(String[] args) {
        int retCode;
        try {
            UniffleAdminCLI cli = new UniffleAdminCLI("", "");
            retCode = cli.run(args);
        }
        catch (UniffleCliArgsException e) {
            retCode = AbstractCustomCommandLine.handleCliArgsException(e, LOG);
        }
        catch (Exception e) {
            retCode = AbstractCustomCommandLine.handleError(e, LOG);
        }
        System.exit(retCode);
    }
}

