/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.uniffle.client.api.ClientInfo;
import org.apache.uniffle.client.api.ShuffleServerClient;
import org.apache.uniffle.client.request.RssGetShuffleDataRequest;
import org.apache.uniffle.client.request.RssGetShuffleIndexRequest;
import org.apache.uniffle.client.response.RssGetShuffleDataResponse;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.ShuffleDataResult;
import org.apache.uniffle.common.ShuffleDataSegment;
import org.apache.uniffle.common.ShuffleIndexResult;
import org.apache.uniffle.common.StorageType;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.exception.RssFetchFailedException;
import org.apache.uniffle.storage.handler.impl.DataSkippableReadHandler;
import org.apache.uniffle.storage.handler.impl.PrefetchableClientReadHandler;
import org.apache.uniffle.storage.handler.impl.ShuffleServerReadCostTracker;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileClientReadHandler
extends DataSkippableReadHandler {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileClientReadHandler.class);
    private final int partitionNumPerRange;
    private final int partitionNum;
    private ShuffleServerClient shuffleServerClient;
    private int retryMax;
    private long retryIntervalMax;
    private ShuffleServerReadCostTracker readCostTracker;
    private boolean nextReadSegmentsReportEnabled;
    private long taskAttemptId;

    public LocalFileClientReadHandler(String appId, int shuffleId, int partitionId, int indexReadLimit, int partitionNumPerRange, int partitionNum, int readBufferSize, Roaring64NavigableMap expectBlockIds, Set<Long> processBlockIds, ShuffleServerClient shuffleServerClient, ShuffleDataDistributionType distributionType, Roaring64NavigableMap expectTaskIds, int retryMax, long retryIntervalMax, Optional<PrefetchableClientReadHandler.PrefetchOption> prefetchOption, ShuffleServerReadCostTracker readCostTracker, boolean nextReadSegmentsReportEnabled, int nextReadSegmentCount, long taskAttemptId) {
        super(appId, shuffleId, partitionId, readBufferSize, expectBlockIds, processBlockIds, distributionType, expectTaskIds, prefetchOption, nextReadSegmentCount);
        this.shuffleServerClient = shuffleServerClient;
        this.partitionNumPerRange = partitionNumPerRange;
        this.partitionNum = partitionNum;
        this.retryMax = retryMax;
        this.retryIntervalMax = retryIntervalMax;
        this.readCostTracker = readCostTracker;
        this.nextReadSegmentsReportEnabled = nextReadSegmentsReportEnabled;
        this.taskAttemptId = taskAttemptId;
    }

    @VisibleForTesting
    public LocalFileClientReadHandler(String appId, int shuffleId, int partitionId, int indexReadLimit, int partitionNumPerRange, int partitionNum, int readBufferSize, Roaring64NavigableMap expectBlockIds, Set<Long> processBlockIds, ShuffleServerClient shuffleServerClient) {
        this(appId, shuffleId, partitionId, indexReadLimit, partitionNumPerRange, partitionNum, readBufferSize, expectBlockIds, processBlockIds, shuffleServerClient, ShuffleDataDistributionType.NORMAL, Roaring64NavigableMap.bitmapOf((long[])new long[0]), 1, 0L, Optional.empty(), new ShuffleServerReadCostTracker(), false, 4, 0L);
    }

    @Override
    public ShuffleIndexResult readShuffleIndex() {
        ShuffleIndexResult shuffleIndexResult = null;
        RssGetShuffleIndexRequest request = new RssGetShuffleIndexRequest(this.appId, this.shuffleId, this.partitionId, this.partitionNumPerRange, this.partitionNum, this.retryMax, this.retryIntervalMax);
        try {
            shuffleIndexResult = this.shuffleServerClient.getShuffleIndex(request).getShuffleIndexResult();
        }
        catch (RssFetchFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RssFetchFailedException("Failed to read shuffle index for appId[" + this.appId + "], shuffleId[" + this.shuffleId + "], partitionId[" + this.partitionId + "]", (Throwable)e);
        }
        return shuffleIndexResult;
    }

    @Override
    public ShuffleDataResult readShuffleData(ShuffleDataSegment shuffleDataSegment, List<ShuffleDataSegment> nextReadSegments) {
        ShuffleDataResult result = null;
        int expectedLength = shuffleDataSegment.getLength();
        if (expectedLength <= 0) {
            throw new RssException("Failed to read shuffle data for appId[" + this.appId + "], shuffleId[" + this.shuffleId + "], partitionId[" + this.partitionId + "], the length field in the index segment is " + expectedLength + " <= 0!");
        }
        RssGetShuffleDataRequest request = new RssGetShuffleDataRequest(this.appId, this.shuffleId, this.partitionId, this.partitionNumPerRange, this.partitionNum, shuffleDataSegment.getOffset(), expectedLength, shuffleDataSegment.getStorageId(), this.retryMax, this.retryIntervalMax, this.taskAttemptId, nextReadSegments, this.nextReadSegmentsReportEnabled);
        try {
            long start = System.currentTimeMillis();
            RssGetShuffleDataResponse response = this.shuffleServerClient.getShuffleData(request);
            result = new ShuffleDataResult(response.getShuffleData(), shuffleDataSegment.getBufferSegments());
            ClientInfo clientInfo = this.shuffleServerClient.getClientInfo();
            if (this.readCostTracker != null && clientInfo != null) {
                this.readCostTracker.record(clientInfo.getShuffleServerInfo().getId(), StorageType.LOCALFILE, result.getDataLength(), System.currentTimeMillis() - start);
            }
        }
        catch (Exception e) {
            throw new RssException("Failed to read shuffle data with " + this.shuffleServerClient.getClientInfo(), (Throwable)e);
        }
        if (result.getDataBuffer().remaining() != expectedLength) {
            throw new RssException("Wrong data length expect " + expectedLength + " but actual is " + result.getDataBuffer().remaining());
        }
        return result;
    }
}

